/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.blocks;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedBlocksEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;

public final class SetBlocksAreaTypeAction
extends WorldAction {
    public SetBlocksAreaTypeAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getArguments().pathExists("first") || !this.getArguments().pathExists("second")) {
            return;
        }
        Location firstLocation = this.getArguments().getValue("first", this.getWorld().getSpawnLocation(), (Action)this);
        Location secondLocation = this.getArguments().getValue("second", this.getWorld().getSpawnLocation(), (Action)this);
        Material type = this.getArguments().getValue("type", Material.AIR, (Action)this);
        int minX = Math.min(firstLocation.getBlockX(), secondLocation.getBlockX());
        int minY = Math.min(firstLocation.getBlockY(), secondLocation.getBlockY());
        int minZ = Math.min(firstLocation.getBlockZ(), secondLocation.getBlockZ());
        int maxX = Math.max(firstLocation.getBlockX(), secondLocation.getBlockX());
        int maxY = Math.max(firstLocation.getBlockY(), secondLocation.getBlockY());
        int maxZ = Math.max(firstLocation.getBlockZ(), secondLocation.getBlockZ());
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                SetBlocksAreaTypeAction.this.getPlanet().getLimits().setLastModifiedBlocksAmount(0);
            }
        };
        this.getPlanet().getTerritory().addBukkitRunnable(runnable);
        type = switch (type) {
            case Material.WATER_BUCKET -> Material.WATER;
            case Material.LAVA_BUCKET -> Material.LAVA;
            case Material.POWDER_SNOW_BUCKET -> Material.POWDER_SNOW;
            case Material.FLINT_AND_STEEL -> Material.FIRE;
            default -> type;
        };
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.getPlanet().getLimits().getLastModifiedBlocksAmount() > this.getPlanet().getLimits().getModifyingBlocksLimit()) {
                        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
                        this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
                        new LimitReachedBlocksEvent(this.getPlanet()).callEvent();
                        return;
                    }
                    this.getPlanet().getLimits().setLastModifiedBlocksAmount(this.getPlanet().getLimits().getLastModifiedBlocksAmount() + 1);
                    Block block = this.getWorld().getBlockAt(x, y, z);
                    if (!type.isBlock() || BlockUtils.isOutOfBorders(block.getLocation())) continue;
                    block.setType(type, false);
                }
            }
        }
        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
        this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SET_BLOCKS_AREA_TYPE;
    }
}

