/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.blocks;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedBlocksEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class SetSignLineAction
extends WorldAction {
    public SetSignLineAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        Side side;
        Location location = this.getArguments().getValue("location", this.getWorld().getSpawnLocation(), (Action)this);
        int number = this.getArguments().getValue("number", 1, (Action)this);
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        String text = this.getArguments().getValue("text", "", (Action)this);
        String sideString = this.getArguments().getValue("side", "front", (Action)this);
        Side side2 = side = sideString.equals("back") ? Side.BACK : Side.FRONT;
        if (number <= 0 || number > sign.getSide(side).lines().size()) {
            number = 1;
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                SetSignLineAction.this.getPlanet().getLimits().setLastModifiedBlocksAmount(0);
            }
        };
        if (this.getPlanet().getLimits().getLastModifiedBlocksAmount() > this.getPlanet().getLimits().getModifyingBlocksLimit()) {
            runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
            this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
            new LimitReachedBlocksEvent(this.getPlanet()).callEvent();
            return;
        }
        sign.getSide(side).setLine(number - 1, text);
        sign.update();
        this.getPlanet().getLimits().setLastModifiedBlocksAmount(this.getPlanet().getLimits().getLastModifiedBlocksAmount() + 1);
        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
        this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SET_SIGN_LINE;
    }
}

