/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.entity;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class SpawnArrowAction
extends WorldAction {
    public SpawnArrowAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        ItemStack arrowItem = this.getArguments().getValue("arrow", new ItemStack(Material.ARROW, 1), (Action)this);
        for (Location location : this.getArguments().getLocationList("locations", this)) {
            Arrow arrow;
            Entity spawnedEntity;
            if (arrowItem.getType() == Material.ARROW) {
                spawnedEntity = this.getPlanet().getTerritory().getWorld().spawnEntity(location, EntityType.ARROW);
                if (!(spawnedEntity instanceof Arrow)) continue;
                arrow = (Arrow)spawnedEntity;
                arrow.setItemStack(arrowItem);
                continue;
            }
            if (arrowItem.getType() != Material.SPECTRAL_ARROW || !((spawnedEntity = this.getPlanet().getTerritory().getWorld().spawnEntity(location, EntityType.SPECTRAL_ARROW)) instanceof SpectralArrow)) continue;
            arrow = (SpectralArrow)spawnedEntity;
            arrow.setItemStack(arrowItem);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SPAWN_ARROW;
    }
}

