/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.entity;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class StrikeLightningAction
extends WorldAction {
    public StrikeLightningAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getPlanet().getLimits().canLightningStrike()) {
            return;
        }
        boolean damage = this.getArguments().getValue("damage", true, (Action)this);
        for (Location location : this.getArguments().getLocationList("locations", this)) {
            if (damage) {
                this.getPlanet().getTerritory().getWorld().strikeLightning(location);
                continue;
            }
            this.getPlanet().getTerritory().getWorld().strikeLightningEffect(location);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_STRIKE_LIGHTNING;
    }
}

