/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.WebResponseEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class SendWebRequestAction
extends WorldAction {
    public SendWebRequestAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getPlanet().getLimits().canSendWebRequest()) {
            return;
        }
        final String url = this.getArguments().getValue("url", "", (Action)this);
        final String body = this.getArguments().getValue("body", "", (Action)this);
        final String request = this.getArguments().getValue("request", "GET", (Action)this).toUpperCase();
        final String media = this.getArguments().getValue("media", "text", (Action)this);
        if (url.isEmpty()) {
            return;
        }
        if (!List.of("GET", "POST").contains(request)) {
            throw new IllegalArgumentException("Invalid HTTP method, use GET or POST.");
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("Invalid URL protocol, use http:// or https:// on the start of URL.");
        }
        if (url.toLowerCase().startsWith("http://localhost") || url.toLowerCase().startsWith("http://127.0.0.1") || url.toLowerCase().startsWith("https://localhost") || url.toLowerCase().startsWith("https://127.0.0.1")) {
            throw new IllegalArgumentException("This URL is blocked from sending requests.");
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    int code;
                    HttpURLConnection connection = SendWebRequestAction.getHttpURLConnection(SendWebRequestAction.this.getPlanet().getId(), url, request, media);
                    if ("POST".equalsIgnoreCase(request) && !body.isEmpty()) {
                        try (OutputStream os = connection.getOutputStream();){
                            os.write(body.getBytes(StandardCharsets.UTF_8));
                        }
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader((code = connection.getResponseCode()) >= 400 ? connection.getErrorStream() : connection.getInputStream()));){
                        char[] buffer = new char[1024];
                        int read = reader.read(buffer);
                        String response = new String(buffer, 0, Math.max(0, read));
                        Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> new WebResponseEvent(SendWebRequestAction.this.getPlanet(), url, code, response).callEvent());
                    }
                }
                catch (Exception e) {
                    Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> new WebResponseEvent(SendWebRequestAction.this.getPlanet(), url, 408, "Error: " + e.getMessage()));
                }
            }
        }.runTaskAsynchronously((Plugin)OpenCreative.getPlugin());
    }

    private static HttpURLConnection getHttpURLConnection(int id, String url, String request, String media) throws IOException {
        URL requestUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod(request);
        connection.setRequestProperty("User-Agent", "OpenCreative+ Web Request, World ID: " + id);
        connection.setDoOutput("POST".equalsIgnoreCase(request));
        if ("json".equalsIgnoreCase(media)) {
            connection.setRequestProperty("Content-Type", "application/json");
        } else {
            connection.setRequestProperty("Content-Type", "text/plain");
        }
        return connection;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SEND_WEB_REQUEST;
    }
}

