/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world;

import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class SetWeatherAction
extends WorldAction {
    public SetWeatherAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        String weather = this.getArguments().getValue("weather", "clean", (Action)this);
        int duration = this.getArguments().getValue("duration", 6000, (Action)this);
        switch (weather.toLowerCase()) {
            case "storm": {
                this.getPlanet().getTerritory().getWorld().setStorm(true);
                if (duration < 0) break;
                this.getPlanet().getTerritory().getWorld().setWeatherDuration(duration);
                break;
            }
            case "thunder": {
                this.getPlanet().getTerritory().getWorld().setThundering(true);
                if (duration < 0) break;
                this.getPlanet().getTerritory().getWorld().setThunderDuration(duration);
                break;
            }
            default: {
                this.getPlanet().getTerritory().getWorld().setClearWeatherDuration(Math.max(duration, 0));
            }
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SET_WEATHER;
    }
}

