/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.entityconditions.other;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.entityconditions.EntityCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public class EntityNameEqualsCondition
extends EntityCondition {
    public EntityNameEqualsCondition(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean check(Entity entity) {
        boolean requiredColor = this.getArguments().getValue("require-color", false, (Action)this);
        boolean requiredCaps = this.getArguments().getValue("require-caps", false, (Action)this);
        List<String> names = this.getArguments().getTextList("names", this);
        String entityName = entity.getName();
        for (String name : names) {
            if (!requiredColor) {
                name = ChatColor.stripColor((String)name);
                entityName = ChatColor.stripColor((String)entityName);
            }
            if (!(requiredCaps ? entityName.equals(name) : entityName.equalsIgnoreCase(name))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_ENTITY_NAME_EQUALS;
    }
}

