/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.inventory;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.PlayerCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public class HasItemInAmountCondition
extends PlayerCondition {
    public HasItemInAmountCondition(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean checkPlayer(Player player) {
        ItemStack item = this.getArguments().getValue("item", new ItemStack(Material.APPLE), (Action)this);
        int amount = this.getArguments().getValue("amount", item.getAmount(), (Action)this);
        String compareMode = this.getArguments().getValue("compare-mode", "full", (Action)this);
        PlayerInventory inv = player.getInventory();
        return switch (compareMode.toLowerCase()) {
            case "full" -> inv.containsAtLeast(item, amount);
            case "material" -> inv.contains(item.getType(), amount);
            default -> false;
        };
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_PLAYER_HAS_ITEM_IN_AMOUNT;
    }
}

