/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.inventory;

import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.PlayerCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public class HasItemInHandCondition
extends PlayerCondition {
    public HasItemInHandCondition(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean checkPlayer(Player player) {
        List<ItemStack> items = this.getArguments().getItemList("items", this);
        if (items.isEmpty()) {
            return false;
        }
        String hand = this.getArguments().getValue("hand", "main-hand", (Action)this);
        boolean ignoreAmount = this.getArguments().getValue("ignore-amount", true, (Action)this);
        boolean ignoreName = this.getArguments().getValue("ignore-name", false, (Action)this);
        boolean ignoreLore = this.getArguments().getValue("ignore-lore", false, (Action)this);
        boolean ignoreEnchantments = this.getArguments().getValue("ignore-enchantments", false, (Action)this);
        boolean ignoreFlags = this.getArguments().getValue("ignore-flags", false, (Action)this);
        boolean ignoreMaterial = this.getArguments().getValue("ignore-material", false, (Action)this);
        boolean ignoreDamage = this.getArguments().getValue("ignore-damage", false, (Action)this);
        ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        itemInMainHand = ItemUtils.getItemWithIgnoreData(itemInMainHand, ignoreAmount, ignoreName, ignoreLore, ignoreFlags, ignoreEnchantments, ignoreMaterial, ignoreDamage);
        ItemStack itemInOffHand = player.getInventory().getItemInOffHand();
        itemInOffHand = ItemUtils.getItemWithIgnoreData(itemInOffHand, ignoreAmount, ignoreName, ignoreLore, ignoreFlags, ignoreEnchantments, ignoreMaterial, ignoreDamage);
        Iterator<ItemStack> iterator = items.iterator();
        if (iterator.hasNext()) {
            ItemStack checkItem = iterator.next();
            checkItem = ItemUtils.getItemWithIgnoreData(checkItem, ignoreAmount, ignoreName, ignoreLore, ignoreFlags, ignoreEnchantments, ignoreMaterial, ignoreDamage);
            if (hand.equals("main-hand")) {
                return itemInMainHand.equals((Object)checkItem);
            }
            if (hand.equals("off-hand")) {
                return itemInOffHand.equals((Object)checkItem);
            }
            return hand.equals("main-or-off-hands") ? itemInMainHand.equals((Object)checkItem) || itemInOffHand.equals((Object)checkItem) : itemInMainHand.equals((Object)checkItem) && itemInOffHand.equals((Object)checkItem);
        }
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_PLAYER_HAS_ITEM_IN_HAND;
    }
}

