/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.inventory;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.PlayerCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public class IsInventoryNameEqualsCondition
extends PlayerCondition {
    public IsInventoryNameEqualsCondition(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean checkPlayer(Player player) {
        boolean requiredColor = this.getArguments().getValue("color", false, (Action)this);
        boolean requiredCaps = this.getArguments().getValue("caps", false, (Action)this);
        List<String> names = this.getArguments().getTextList("names", this);
        String title = player.getOpenInventory().getTitle();
        for (String name : names) {
            if (!requiredColor) {
                name = ChatColor.stripColor((String)name);
                title = ChatColor.stripColor((String)title);
            }
            if (!(requiredCaps ? title.equals(name) : title.equalsIgnoreCase(name))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_PLAYER_INVENTORY_NAME_EQUALS;
    }
}

