/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.params;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.PlayerCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public class HasPotionEffectsCondition
extends PlayerCondition {
    public HasPotionEffectsCondition(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean checkPlayer(Player player) {
        List<ItemStack> potionsItems = this.getArguments().getItemList("potions", this);
        boolean requireAll = this.getArguments().getValue("all", false, (Action)this);
        boolean hasEffect = false;
        for (ItemStack potionItem : potionsItems) {
            PotionMeta potionMeta = (PotionMeta)potionItem.getItemMeta();
            ArrayList effects = new ArrayList();
            if (potionMeta.getBasePotionType() != null) {
                effects.addAll(potionMeta.getBasePotionType().getPotionEffects());
            }
            if (potionMeta.hasCustomEffects()) {
                effects.addAll(potionMeta.getCustomEffects());
            }
            for (PotionEffect potionEffect : effects) {
                if (player.hasPotionEffect(potionEffect.getType())) {
                    if (!requireAll) {
                        return true;
                    }
                    hasEffect = true;
                    continue;
                }
                if (requireAll) {
                    return false;
                }
                hasEffect = false;
            }
        }
        return hasEffect;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_PLAYER_HAS_POTION_EFFECTS;
    }
}

