/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.events;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executors;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public class WorldListener
implements EventExecutor,
Listener {
    public void registerExecutors() {
        try {
            Bukkit.getPluginManager().registerEvent(WorldEvent.class, (Listener)this, EventPriority.NORMAL, (EventExecutor)this, (Plugin)OpenCreative.getPlugin());
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("Cannot register world events listener: planets code will not work.", error);
        }
    }

    public boolean canActivate(@NotNull WorldEvent worldEvent) {
        if (worldEvent == null) {
            WorldListener.$$$reportNull$$$0(0);
        }
        if (worldEvent.getPlanet() == null) {
            return false;
        }
        if (worldEvent.getWorld() == null) {
            return false;
        }
        if (!WorldUtils.isPlanet(worldEvent.getWorld())) {
            return false;
        }
        if (WorldUtils.isDevPlanet(worldEvent.getWorld())) {
            return false;
        }
        if (!worldEvent.getPlanet().isLoaded()) {
            return false;
        }
        if (worldEvent.getPlanet().getMode() != Planet.Mode.PLAYING) {
            return false;
        }
        if (!worldEvent.getSelection().isEmpty()) {
            for (Entity entity : worldEvent.getSelection()) {
                if (entity.getWorld().equals((Object)worldEvent.getPlanet().getWorld())) continue;
                return false;
            }
        }
        return true;
    }

    public void execute(@NotNull Listener listener, @NotNull Event event) throws EventException {
        WorldEvent worldEvent;
        if (listener == null) {
            WorldListener.$$$reportNull$$$0(1);
        }
        if (event == null) {
            WorldListener.$$$reportNull$$$0(2);
        }
        if (event instanceof WorldEvent && this.canActivate(worldEvent = (WorldEvent)event)) {
            Executors.activate(worldEvent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worldEvent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/blocks/events/WorldListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canActivate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

