/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.executors;

import java.util.ArrayList;
import java.util.List;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.ChatEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public abstract class Executor {
    private final Planet planet;
    private final int x;
    private final int y;
    private final int z;
    private final List<Action> actions = new ArrayList<Action>();
    private WorldEvent event;
    private ActionsHandler handler;

    public Executor(Planet planet, int x, int y, int z) {
        this.planet = planet;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void run(WorldEvent event) {
        if (this.getExecutorType() != null && this.getExecutorType().isDisabled()) {
            return;
        }
        ErrorUtils.sendCodingDebugExecutor(this);
        this.executeActions(event);
    }

    protected void executeActions(WorldEvent event) {
        this.event = event;
        this.handler = new ActionsHandler(this);
        if (event instanceof ChatEvent) {
            ChatEvent chatEvent = (ChatEvent)event;
            if (!this.actions.isEmpty()) {
                chatEvent.setHandledByCode(true);
            }
        }
        this.handler.executeActions(this.actions);
    }

    public final void setActions(List<Action> actions) {
        this.actions.clear();
        actions.forEach(this::addAction);
    }

    private void addAction(Action action) {
        this.actions.add(action);
    }

    public abstract ExecutorType getExecutorType();

    public abstract ExecutorCategory getExecutorCategory();

    public String toString() {
        return "Executor | Planet: " + this.getPlanet().getWorldName() + " Coords: " + this.x + " " + this.y + " " + this.z;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final Planet getPlanet() {
        return this.planet;
    }

    public WorldEvent getEvent() {
        return this.event;
    }

    public ActionsHandler getHandler() {
        return this.handler;
    }

    public List<Action> getActions() {
        return this.actions;
    }
}

