/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.executors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.other.Function;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.other.Method;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class Executors {
    protected final Planet planet;
    private final List<Executor> executorsList = new ArrayList<Executor>();
    private final Map<Executor, Integer> lastExecutorsCallsAmount = new HashMap<Executor, Integer>();

    public Executors(Planet planet) {
        this.planet = planet;
    }

    public void clear() {
        this.executorsList.clear();
        this.lastExecutorsCallsAmount.clear();
    }

    public static void activate(WorldEvent event) {
        Planet planet = event.getPlanet();
        if (planet == null || planet.getTerritory().getScript() == null || planet.getTerritory().getScript().getExecutors() == null) {
            return;
        }
        Executors executors = planet.getTerritory().getScript().getExecutors();
        for (Executor executor : executors.executorsList) {
            if (executor.getExecutorType().getEventClass() != ((Object)((Object)event)).getClass()) continue;
            Executors.activate(executor, event);
        }
    }

    public static void activate(final Executor executor, WorldEvent event) {
        Planet planet = executor.getPlanet();
        if (planet == null || planet.getTerritory().getScript() == null || planet.getTerritory().getScript().getExecutors() == null) {
            return;
        }
        final Executors executors = planet.getTerritory().getScript().getExecutors();
        if (executors.getLastExecutorCallsAmount(executor) > planet.getLimits().getCodeOperationsLimit()) {
            executors.clearExecutionsAmount(executor);
            ErrorUtils.stopPlanetCode(planet);
            ErrorUtils.sendPlanetCodeCriticalErrorMessage(planet, executor, MessageUtils.getLocaleMessage("coding-error.operations-limit", false).replace("%limit%", String.valueOf(planet.getLimits().getCodeOperationsLimit())));
        } else {
            executors.increaseCallsAmount(executor);
            executor.run(event);
            new BukkitRunnable(){

                public void run() {
                    executors.decreaseCallsAmount(executor);
                }
            }.runTaskLater((Plugin)OpenCreative.getPlugin(), 35L);
        }
    }

    public static void simulateIncreaseCall(final Executor executor) {
        Planet planet = executor.getPlanet();
        final Executors executors = planet.getTerritory().getScript().getExecutors();
        if (executors.getLastExecutorCallsAmount(executor) > planet.getLimits().getCodeOperationsLimit()) {
            executors.clearExecutionsAmount(executor);
            ErrorUtils.stopPlanetCode(planet);
            ErrorUtils.sendPlanetCodeCriticalErrorMessage(planet, executor, MessageUtils.getLocaleMessage("coding-error.operations-limit", false).replace("%limit%", String.valueOf(planet.getLimits().getCodeOperationsLimit())));
        } else {
            executors.increaseCallsAmount(executor);
            new BukkitRunnable(){

                public void run() {
                    executors.decreaseCallsAmount(executor);
                }
            }.runTaskLater((Plugin)OpenCreative.getPlugin(), 35L);
        }
    }

    public void load(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection section = config.getConfigurationSection("code.blocks");
        if (section != null) {
            long time = System.currentTimeMillis();
            ArrayList<Executor> executors = new ArrayList<Executor>();
            Set keys = section.getKeys(false);
            for (String key : keys) {
                Executor executor;
                String path = "code.blocks." + key;
                if (config.getString(path + ".type") == null || (executor = this.createExecutor(config, path)) == null || executor.getExecutorType() == null) continue;
                executors.add(executor);
            }
            this.clear();
            this.executorsList.addAll(executors);
            ErrorUtils.sendCodingDebugLog(this.planet, "Started code in " + (System.currentTimeMillis() - time) + " ms with " + executors.size() + " executors!");
        } else {
            ErrorUtils.sendCodingDebugLog(this.planet, "No code found to load.");
        }
    }

    public List<Executor> getExecutorsList() {
        return this.executorsList;
    }

    public List<Function> getFunctionsList() {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Executor executor : this.executorsList) {
            if (!(executor instanceof Function)) continue;
            Function function = (Function)executor;
            functions.add(function);
        }
        return functions;
    }

    public List<Method> getMethodsList() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Executor executor : this.executorsList) {
            if (!(executor instanceof Method)) continue;
            Method method = (Method)executor;
            methods.add(method);
        }
        return methods;
    }

    private int[] getCoords(YamlConfiguration config, String path) {
        int[] coords = new int[]{config.getInt(path + ".location.x"), config.getInt(path + ".location.y"), config.getInt(path + ".location.z")};
        return coords;
    }

    private Executor createExecutor(YamlConfiguration config, String path) {
        Executor executor = null;
        try {
            int[] coords = this.getCoords(config, path);
            ExecutorType type = ExecutorType.valueOf(config.getString(path + ".type"));
            if (type == ExecutorType.CYCLE) {
                name = config.getString(path + ".name");
                int time = config.getInt(path + ".time");
                if (name != null) {
                    executor = type.getExecutorClass().getConstructor(Planet.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE).newInstance(this.planet, coords[0], coords[1], coords[2], name, time >= 5 && time <= 3600 ? time : 20);
                }
            } else if (type == ExecutorType.FUNCTION || type == ExecutorType.METHOD) {
                name = config.getString(path + ".name");
                if (name != null) {
                    executor = type.getExecutorClass().getConstructor(Planet.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class).newInstance(this.planet, coords[0], coords[1], coords[2], name);
                }
            } else {
                executor = type.getExecutorClass().getConstructor(Planet.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(this.planet, coords[0], coords[1], coords[2]);
            }
            List<Action> allActionsList = this.createActionList(executor, path + ".actions", config);
            if (!allActionsList.isEmpty()) {
                executor.setActions(allActionsList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return executor;
    }

    private List<Action> createActionList(Executor executor, String path, YamlConfiguration config) {
        ArrayList<Action> actionList = new ArrayList<Action>();
        ConfigurationSection actions = config.getConfigurationSection(path);
        if (actions != null) {
            Set actionsBlocks = actions.getKeys(false);
            for (String actionBlock : actionsBlocks) {
                String actionPath = path + "." + actionBlock;
                Action action = this.createAction(executor, actionPath, config);
                if (action == null) continue;
                actionList.add(action);
            }
        }
        return actionList;
    }

    private Action createAction(Executor executor, String path, YamlConfiguration config) {
        String type = config.getString(path + ".type");
        if (type == null) {
            return null;
        }
        try {
            ConfigurationSection section;
            ActionType actionType = ActionType.valueOf(type);
            Arguments args = new Arguments(executor.getPlanet(), executor);
            Target target = Target.DEFAULT;
            String targetString = config.getString(path + ".target");
            if (targetString != null && !targetString.isEmpty()) {
                target = Target.valueOf(targetString);
            }
            if ((section = config.getConfigurationSection(path + ".arguments")) != null) {
                args.load(section);
            }
            if (actionType == ActionType.LAUNCH_FUNCTION || actionType == ActionType.LAUNCH_METHOD) {
                if (config.getString(path + ".name") != null) {
                    args.setArgumentValue("name", ValueType.TEXT, config.getString(path + ".name", " "));
                }
            } else if (actionType == ActionType.SELECTION_SET || actionType == ActionType.SELECTION_ADD || actionType == ActionType.SELECTION_REMOVE) {
                if (config.getConfigurationSection(path + ".condition") != null) {
                    boolean isOpposed = config.getBoolean(path + ".condition.opposed", false);
                    ActionCategory conditionCategory = ActionCategory.valueOf(config.getString(path + ".condition.category"));
                    ActionType conditionType = ActionType.valueOf(config.getString(path + ".condition.type"));
                    return actionType.getActionClass().getConstructor(Executor.class, Integer.TYPE, Arguments.class, ActionCategory.class, ActionType.class, Boolean.TYPE).newInstance(new Object[]{executor, config.getInt(path + ".location.x"), args, conditionCategory, conditionType, isOpposed});
                }
                if (config.getString(path + ".target") != null) {
                    if (targetString != null && !targetString.isEmpty()) {
                        target = Target.valueOf(targetString);
                    }
                    return actionType.getActionClass().getConstructor(Executor.class, Integer.TYPE, Arguments.class, Target.class).newInstance(new Object[]{executor, config.getInt(path + ".location.x"), args, target});
                }
                if (config.getString(path + ".condition.type") != null) {
                    args.setArgumentValue("name", ValueType.TEXT, config.getString(path + ".name", ""));
                }
            }
            if (actionType.getCategory().isMultiAction() && config.getConfigurationSection(path + ".actions") != null) {
                if (actionType.getCategory().isCondition()) {
                    boolean isOpposed = config.getBoolean(path + ".opposed", false);
                    return actionType.getActionClass().getConstructor(Executor.class, Target.class, Integer.TYPE, Arguments.class, List.class, List.class, Boolean.TYPE).newInstance(new Object[]{executor, target, config.getInt(path + ".location.x"), args, this.createActionList(executor, path + ".actions", config), this.createActionList(executor, path + ".else", config), isOpposed});
                }
                return actionType.getActionClass().getConstructor(Executor.class, Target.class, Integer.TYPE, Arguments.class, List.class).newInstance(new Object[]{executor, target, config.getInt(path + ".location.x"), args, this.createActionList(executor, path + ".actions", config)});
            }
            return actionType.getActionClass().getConstructor(Executor.class, Target.class, Integer.TYPE, Arguments.class).newInstance(new Object[]{executor, target, config.getInt(path + ".location.x"), args});
        }
        catch (Exception error) {
            ErrorUtils.sendDebugError("Can't create an action", error);
            return null;
        }
    }

    private void increaseCallsAmount(Executor executor) {
        this.lastExecutorsCallsAmount.put(executor, this.getLastExecutorCallsAmount(executor) + 1);
    }

    private void decreaseCallsAmount(Executor executor) {
        this.lastExecutorsCallsAmount.put(executor, this.getLastExecutorCallsAmount(executor) - 1);
    }

    private int getLastExecutorCallsAmount(Executor executor) {
        if (!this.lastExecutorsCallsAmount.containsKey(executor)) {
            return 0;
        }
        return this.lastExecutorsCallsAmount.get(executor);
    }

    private void clearExecutionsAmount(Executor executor) {
        this.lastExecutorsCallsAmount.remove(executor);
    }
}

