/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public enum MenusCategory {
    FIGHTING(Material.NETHERITE_SWORD),
    INTERACTION(Material.GRASS_BLOCK),
    INVENTORY(Material.DARK_OAK_CHEST_BOAT),
    MOVEMENT(Material.CHAINMAIL_BOOTS),
    BLOCKS(Material.BRICKS),
    WORLD(Material.CHAIN_COMMAND_BLOCK),
    ENTITY(Material.VILLAGER_SPAWN_EGG),
    COMMUNICATION(Material.JUNGLE_SIGN),
    STATE(Material.ANVIL),
    LINES(Material.CALIBRATED_SCULK_SENSOR),
    APPEARANCE(Material.ARMOR_STAND),
    EVENTS(Material.END_CRYSTAL),
    PARAMS(Material.APPLE),
    PLAYER(Material.PLAYER_HEAD),
    OTHER(Material.PUMPKIN_SEEDS),
    ENTITY_STATE(Material.ANVIL),
    ENTITY_PARAMS(Material.APPLE),
    ENTITY_MOVEMENT(Material.NETHERITE_BOOTS),
    ENTITY_INTERACTION(Material.DARK_OAK_CHEST_BOAT),
    ENTITY_FIGHTING(Material.NETHERITE_SWORD),
    WORLD_OTHER(Material.AMETHYST_CLUSTER),
    WORLD_INVENTORY(Material.MANGROVE_CHEST_BOAT),
    WORLD_BLOCKS(Material.CAMPFIRE),
    TEXT_OPERATIONS(Material.BOOK),
    NUMBER_OPERATIONS(Material.SLIME_BALL),
    LOCATION_OPERATIONS(Material.PAPER),
    ITEM_OPERATIONS(Material.GLOW_ITEM_FRAME),
    LIST_OPERATIONS(Material.BOOKSHELF),
    MAP_OPERATIONS(Material.CHEST_MINECART),
    VECTOR_OPERATIONS(Material.PRISMARINE_SHARD),
    REPEATS(Material.PRISMARINE_CRYSTALS),
    CONTROLLER(Material.COMPASS);

    private final Material material;

    private MenusCategory(Material material) {
        this.material = material;
    }

    public ItemStack getItem(String blockCategory) {
        return ItemUtils.createItem(this.material, 1, "items.developer.categories." + blockCategory + "." + this.name().toLowerCase(), this.name().toLowerCase());
    }

    public static MenusCategory getByIcon(ItemStack icon) {
        if (icon == null) {
            return null;
        }
        String type = ItemUtils.getItemType(icon);
        for (MenusCategory category : MenusCategory.values()) {
            if (!category.name().equalsIgnoreCase(type)) continue;
            return category;
        }
        return null;
    }
}

