/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class TargetSelectionMenu
extends AbstractMenu {
    private final Location signLocation;

    public TargetSelectionMenu(Location location) {
        super(1, MessageUtils.getLocaleMessage("menus.developer.selection.title"));
        this.signLocation = location;
    }

    @Override
    public void fillItems(Player player) {
        int slot = 0;
        for (Target target : Target.values()) {
            this.setItem(slot, ItemUtils.createItem(target.getIcon(), 1, "menus.developer.selection.items." + target.name().toLowerCase().replace("_", "-")));
            ++slot;
        }
        if (slot < this.getSize()) {
            while (slot < this.getSize()) {
                this.setItem(slot, this.DECORATION_ITEM);
                ++slot;
            }
        }
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            TargetSelectionMenu.$$$reportNull$$$0(0);
        }
        if (this.isPlayerClicked(event) && this.isClickedInMenuSlots(event)) {
            Player player = (Player)event.getWhoClicked();
            ItemStack item = event.getCurrentItem();
            event.setCancelled(true);
            if (item != null && !item.equals((Object)this.DECORATION_ITEM)) {
                Target selection = Target.getByMaterial(item.getType());
                if (selection == Target.DEFAULT) {
                    BlockUtils.setSignLine(this.signLocation, 4, "");
                } else {
                    BlockUtils.setSignLine(this.signLocation, 4, selection.name().toLowerCase());
                }
                PlayerUtils.translateBlockSign(this.signLocation.getBlock());
                player.closeInventory();
                Sounds.DEV_SET_TARGET.play((Audience)player);
            }
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            TargetSelectionMenu.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/menus/TargetSelectionMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

