/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus;

import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ValueTargetSelectionMenu
extends AbstractMenu {
    private final Player player;

    public ValueTargetSelectionMenu(@NotNull Player player) {
        if (player == null) {
            ValueTargetSelectionMenu.$$$reportNull$$$0(0);
        }
        super(1, MessageUtils.getLocaleMessage("menus.developer.selection.title-values"));
        this.player = player;
    }

    @Override
    public void fillItems(Player player) {
        int slot = 0;
        for (Target target : Target.values()) {
            if (!target.isSupportsEventValue()) continue;
            this.setItem(slot, ItemUtils.createItem(target.getIcon(), 1, "menus.developer.selection.items." + target.name().toLowerCase().replace("_", "-")));
            ++slot;
        }
        if (slot < this.getSize()) {
            while (slot < this.getSize()) {
                this.setItem(slot, this.DECORATION_ITEM);
                ++slot;
            }
        }
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            ValueTargetSelectionMenu.$$$reportNull$$$0(1);
        }
        if (this.isPlayerClicked(event) && this.isClickedInMenuSlots(event)) {
            ItemStack item = event.getCurrentItem();
            event.setCancelled(true);
            if (item == null || item.equals((Object)this.DECORATION_ITEM)) {
                return;
            }
            ItemStack itemInHand = this.player.getInventory().getItemInMainHand();
            Target target = Target.getByMaterial(item.getType());
            ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingTargetTypeKey(), target.name());
            ItemMeta meta = itemInHand.getItemMeta();
            meta.setLore(MessageUtils.getLocaleItemDescription("menus.developer.variables.items.event-value.lore"));
            itemInHand.setItemMeta(meta);
            ItemUtils.addLoreAtBegin(itemInHand, MessageUtils.getLocaleMessage("menus.developer.event-values.target").replace("%target%", target.getLocaleName()));
            this.player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-target")), (Component)MessageUtils.toComponent(target.getLocaleName()), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
            this.player.closeInventory();
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            ValueTargetSelectionMenu.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/menus/ValueTargetSelectionMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

