/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.blocks;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.menus.blocks.BlocksCategorySelectionMenu;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.Layout;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class SelectionActionsMenu
extends AbstractMenu {
    private final Player player;
    private final Location signLocation;
    private final ItemStack varCondition = ItemUtils.createItem(Material.OBSIDIAN, 1, "items.developer.variable-condition");
    private final ItemStack playerCondition = ItemUtils.createItem(Material.OAK_PLANKS, 1, "items.developer.player-condition");
    private final ItemStack entityCondition = ItemUtils.createItem(Material.BRICKS, 1, "items.developer.entity-condition");
    private final ItemStack defaultItem = ItemUtils.createItem(Target.DEFAULT.getIcon(), 1, "menus.developer.selection.items.default");
    private final ItemStack allPlayers = ItemUtils.createItem(Target.ALL_PLAYERS.getIcon(), 1, "menus.developer.selection.items.all-players");
    private final ItemStack allEntities = ItemUtils.createItem(Target.ALL_ENTITIES.getIcon(), 1, "menus.developer.selection.items.all-entities");
    private final ItemStack randomTarget = ItemUtils.createItem(Target.RANDOM_TARGET.getIcon(), 1, "menus.developer.selection.items.random-target");
    private final ItemStack randomPlayer = ItemUtils.createItem(Target.RANDOM_PLAYER.getIcon(), 1, "menus.developer.selection.items.random-player");
    private final ItemStack victim = ItemUtils.createItem(Target.VICTIM.getIcon(), 1, "menus.developer.selection.items.victim");
    private final ItemStack killer = ItemUtils.createItem(Target.KILLER.getIcon(), 1, "menus.developer.selection.items.killer");

    public SelectionActionsMenu(Player player, Location location) {
        super(5, MessageUtils.getLocaleMessage("blocks.selection_action", false));
        this.player = player;
        this.signLocation = location;
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(10, this.defaultItem);
        this.setItem(12, this.randomTarget);
        this.setItem(13, this.randomPlayer);
        this.setItem(16, this.playerCondition);
        this.setItem(19, this.allPlayers);
        this.setItem(25, this.entityCondition);
        this.setItem(28, this.allEntities);
        this.setItem(30, this.killer);
        this.setItem(31, this.victim);
        this.setItem(34, this.varCondition);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            SelectionActionsMenu.$$$reportNull$$$0(0);
        }
        if (!this.isClickedInMenuSlots(event) || !this.isPlayerClicked(event)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        if (ItemUtils.itemEquals(currentItem, this.playerCondition)) {
            new BlocksCategorySelectionMenu(this.player, this.signLocation, ActionCategory.PLAYER_CONDITION).open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.entityCondition)) {
            new BlocksCategorySelectionMenu(this.player, this.signLocation, ActionCategory.ENTITY_CONDITION).open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.varCondition)) {
            new BlocksCategorySelectionMenu(this.player, this.signLocation, ActionCategory.VARIABLE_CONDITION).open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.allPlayers)) {
            this.setLine("all_players");
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
            event.getWhoClicked().swingMainHand();
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.randomPlayer)) {
            this.setLine("random_player");
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
            event.getWhoClicked().swingMainHand();
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.killer)) {
            this.setLine("killer");
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
            event.getWhoClicked().swingMainHand();
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.victim)) {
            this.setLine("victim");
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
            event.getWhoClicked().swingMainHand();
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.randomTarget)) {
            this.setLine("random_target");
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
            event.getWhoClicked().swingMainHand();
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.allEntities)) {
            this.setLine("all_entities");
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
            event.getWhoClicked().swingMainHand();
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.defaultItem)) {
            this.setLine("");
            Sounds.DEV_SET_TARGET.play((Audience)this.player);
            event.getWhoClicked().swingMainHand();
            this.player.closeInventory();
        }
    }

    private void setLine(String text) {
        BlockUtils.setSignLine(this.signLocation, 1, "");
        BlockUtils.setSignLine(this.signLocation, 2, text);
        BlockUtils.setSignLine(this.signLocation, 3, "");
        PlayerUtils.translateBlockSign(this.signLocation.getBlock());
        Block containerBlock = this.signLocation.getBlock().getRelative(BlockFace.UP).getRelative(BlockFace.NORTH);
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(this.signLocation.getWorld());
        if (devPlanet == null) {
            containerBlock.setType(Material.AIR);
            return;
        }
        devPlanet.setCodeChanged(true);
        Layout layout = devPlanet.getOpenedMenu(containerBlock.getLocation());
        if (layout != null) {
            for (Player viewer : layout.getViewers()) {
                viewer.closeInventory();
            }
            devPlanet.unregisterOpenedMenu(containerBlock.getLocation());
        }
        containerBlock.setType(Material.AIR);
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            SelectionActionsMenu.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/menus/blocks/SelectionActionsMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

