/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.layouts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.ArgumentSlot;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;

public class ParameterSlot
extends ArgumentSlot {
    private final List<Object> values = new ArrayList<Object>();
    private final List<Material> icons = new ArrayList<Material>();

    public ParameterSlot(String path, List<Object> values, Material ... materials) {
        super(path, ValueType.PARAMETER);
        this.values.addAll(values);
        this.icons.addAll(Arrays.asList(materials));
    }

    public ParameterSlot(String path, Material ... materials) {
        super(path, ValueType.PARAMETER);
        this.values.add(false);
        this.values.add(true);
        if (Arrays.asList(materials).isEmpty()) {
            this.icons.add(Material.GRAY_DYE);
            this.icons.add(Material.LIME_DYE);
        } else {
            this.icons.addAll(Arrays.asList(materials));
        }
    }

    public ParameterSlot(String path, boolean firstValue, Material trueMaterial, Material falseMaterial) {
        super(path, ValueType.PARAMETER);
        this.values.add(firstValue);
        this.values.add(!firstValue);
        this.icons.add(firstValue ? trueMaterial : falseMaterial);
        this.icons.add(firstValue ? falseMaterial : trueMaterial);
    }

    public ParameterSlot(String path, int maxNumber, Material ... materials) {
        super(path, ValueType.PARAMETER);
        for (int i = 0; i < maxNumber; ++i) {
            this.values.add(i);
        }
        this.icons.addAll(Arrays.asList(materials));
    }

    public List<Object> getValues() {
        return this.values;
    }

    public List<Material> getIcons() {
        return this.icons;
    }
}

