/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.variables;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.coding.menus.MenusCategory;
import ua.mcchickenstudio.opencreative.coding.values.EventValue;
import ua.mcchickenstudio.opencreative.coding.values.EventValues;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class EventValuesMenu
extends ListBrowserMenu<EventValue> {
    protected MenusCategory currentCategory = MenusCategory.WORLD;

    public EventValuesMenu(Player player) {
        super(player, ChatColor.stripColor((String)MessageUtils.getLocaleMessage("menus.developer.event-values.title", false)));
    }

    @Override
    protected ItemStack getElementIcon(EventValue value) {
        ItemStack icon = ItemUtils.createItem(value.getDisplayIcon(), "menus.developer.event-values.items." + value.getID().toLowerCase().replace("_", "-"));
        ItemUtils.setPersistentData(icon, ItemUtils.getCodingValueKey(), "EVENT_VALUE");
        ItemUtils.setPersistentData(icon, ItemUtils.getCodingVariableTypeKey(), value.getID().toUpperCase());
        return icon;
    }

    @Override
    protected void fillOtherItems() {
        int slot = 0;
        for (MenusCategory category : this.getMenusCategories()) {
            this.setItem(this.getCharmsBarSlots()[slot], category.getItem("event-values"));
            ++slot;
        }
    }

    protected Set<MenusCategory> getMenusCategories() {
        return new HashSet<MenusCategory>(List.of(MenusCategory.PLAYER, MenusCategory.ENTITY, MenusCategory.EVENTS, MenusCategory.WORLD));
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
        ItemStack clicked = event.getCurrentItem();
        event.setCancelled(true);
        MenusCategory category = MenusCategory.getByIcon(clicked);
        if (category != null) {
            this.setCurrentPage(1);
            Sounds.DEV_CHANGE_CATEGORY.play((Audience)event.getWhoClicked());
            this.currentCategory = category;
            this.elements.clear();
            this.elements.addAll(this.getElements());
            this.fillElements(1);
            this.fillArrowsItems(1);
        }
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        ItemStack itemInHand = this.getPlayer().getInventory().getItemInMainHand();
        event.setCancelled(true);
        if (item == null) {
            return;
        }
        if (item.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        Component displayName = meta.displayName();
        if (displayName == null) {
            return;
        }
        ItemMeta handMeta = itemInHand.getItemMeta();
        handMeta.displayName(displayName);
        itemInHand.setItemMeta(handMeta);
        ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingValueKey(), "EVENT_VALUE");
        ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingVariableTypeKey(), ItemUtils.getPersistentData(item, ItemUtils.getCodingVariableTypeKey()));
        this.getPlayer().closeInventory();
        this.getPlayer().showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)displayName, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
        Sounds.DEV_EVENT_VALUE_SET.play((Audience)event.getWhoClicked());
    }

    @Override
    public List<EventValue> getElements() {
        if (this.currentCategory == null) {
            this.currentCategory = MenusCategory.ENTITY;
        }
        return new ArrayList<EventValue>(EventValues.getInstance().getByCategories(this.currentCategory));
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.developer.event-values.items.next-page");
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.developer.event-values.items.previous-page");
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.developer.event-values.items.no-elements");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            EventValuesMenu.$$$reportNull$$$0(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/coding/menus/variables/EventValuesMenu", "onOpen"));
    }
}

