/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.modules;

import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.CodingBlockPlacer;
import ua.mcchickenstudio.opencreative.coding.modules.ModuleInfo;
import ua.mcchickenstudio.opencreative.events.module.ModuleInstallationEvent;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class Module {
    private final int id;
    private final ModuleInfo info;
    private UUID owner;

    public Module(int id) {
        this.id = id;
        String uuid = FileUtils.getModuleConfig(this).getString("owner", "");
        try {
            this.owner = UUID.fromString(uuid);
        }
        catch (Exception ignored) {
            this.owner = new UUID(0L, 0L);
        }
        this.info = new ModuleInfo(this);
        new BukkitRunnable(){

            public void run() {
                Module.this.info.updateIcon();
            }
        }.runTaskAsynchronously((Plugin)OpenCreative.getPlugin());
    }

    @NotNull
    public UUID getOwner() {
        UUID uUID = this.owner;
        if (uUID == null) {
            Module.$$$reportNull$$$0(0);
        }
        return uUID;
    }

    @NotNull
    public String getOwnerName() {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.owner);
        String offlineName = offlinePlayer.getName();
        return offlinePlayer.hasPlayedBefore() ? (offlineName == null ? "Unknown owner" : offlineName) : "Unknown owner";
    }

    public boolean isOwner(@NotNull OfflinePlayer player) {
        if (player == null) {
            Module.$$$reportNull$$$0(1);
        }
        return this.owner.equals(player.getUniqueId());
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public ModuleInfo getInformation() {
        ModuleInfo moduleInfo = this.info;
        if (moduleInfo == null) {
            Module.$$$reportNull$$$0(2);
        }
        return moduleInfo;
    }

    public boolean place(@NotNull DevPlanet devPlanet, @NotNull Player player) {
        if (devPlanet == null) {
            Module.$$$reportNull$$$0(3);
        }
        if (player == null) {
            Module.$$$reportNull$$$0(4);
        }
        if (!devPlanet.isLoaded()) {
            return false;
        }
        if (!devPlanet.getWorld().getPlayers().contains(player)) {
            return false;
        }
        if (!(this.getInformation().isPublic() || this.isOwner((OfflinePlayer)player) || player.hasPermission("opencreative.modules.private.bypass"))) {
            player.sendMessage(MessageUtils.getLocaleMessage("modules.private"));
            return true;
        }
        FileConfiguration config = FileUtils.getModuleConfig(this);
        ConfigurationSection section = config.getConfigurationSection("code.blocks");
        if (section == null) {
            return true;
        }
        ArrayList<Location> freeColumns = new ArrayList<Location>();
        int requiredColumns = section.getKeys(false).size();
        for (DevPlatform platform : devPlanet.getPlatforms()) {
            freeColumns.addAll(platform.getFreeColumns());
            if (freeColumns.size() < requiredColumns) continue;
            break;
        }
        ModuleInstallationEvent event = new ModuleInstallationEvent(this, player);
        event.callEvent();
        if (event.isCancelled()) {
            return false;
        }
        CodingBlockPlacer placer = new CodingBlockPlacer(devPlanet);
        CodingBlockPlacer.CodePlacementResult result = placer.placeCodingLines(devPlanet, section);
        if (result == CodingBlockPlacer.CodePlacementResult.NOT_ENOUGH_CODING_LINES) {
            player.sendMessage(MessageUtils.getLocaleMessage("modules.few-space").replace("%required%", String.valueOf(requiredColumns)));
            Sounds.DEV_NOT_ALLOWED.play((Audience)player);
            return false;
        }
        if (result == CodingBlockPlacer.CodePlacementResult.ERROR) {
            devPlanet.setCodeChanged(true);
            player.sendMessage(MessageUtils.parseModuleLines(this, MessageUtils.getPlayerLocaleMessage("modules.fail", (OfflinePlayer)player)));
            Sounds.PLAYER_FAIL.play((Audience)player);
            return false;
        }
        devPlanet.setCodeChanged(true);
        Sounds.DEV_MODULE_INSTALLED.play((Audience)player);
        for (Player planetPlayer : devPlanet.getPlanet().getPlayers()) {
            if (!devPlanet.getPlanet().getWorldPlayers().canDevelop(planetPlayer)) continue;
            planetPlayer.sendMessage(MessageUtils.parseModuleLines(this, MessageUtils.getPlayerLocaleMessage("modules.installed", (OfflinePlayer)player)));
        }
        this.getInformation().addDownload(devPlanet.getPlanet());
        return true;
    }

    public int hashCode() {
        return String.valueOf(this.id).hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/coding/modules/Module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devPlanet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/modules/Module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOwner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "place";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

