/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ModuleInfo {
    private final Module module;
    private String displayName;
    private String description;
    private ItemStack icon;
    private int reputation;
    private int downloads;
    private long creationTime;
    private boolean isPublic;

    public ModuleInfo(@NotNull Module module) {
        if (module == null) {
            ModuleInfo.$$$reportNull$$$0(0);
        }
        this.module = module;
        this.loadInformation();
    }

    @NotNull
    public String getDisplayName() {
        String string = this.displayName;
        if (string == null) {
            ModuleInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Component displayName() {
        return LegacyComponentSerializer.legacySection().deserialize(this.displayName).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            ModuleInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public ItemStack getIcon() {
        if (this.module.getInformation().isPublic()) {
            ItemStack itemStack = this.icon;
            if (itemStack == null) {
                ModuleInfo.$$$reportNull$$$0(3);
            }
            return itemStack;
        }
        ItemStack itemStack = this.icon.clone().withType(Material.BARRIER);
        if (itemStack == null) {
            ModuleInfo.$$$reportNull$$$0(4);
        }
        return itemStack;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public long getCreationTime() {
        if (this.creationTime == 0L) {
            return 1670573410000L;
        }
        return this.creationTime;
    }

    public int getReputation() {
        return this.reputation;
    }

    public int getDownloads() {
        return this.downloads;
    }

    private void loadInformation() {
        FileConfiguration config;
        block5: {
            config = FileUtils.getModuleConfig(this.module);
            this.displayName = config.getString("name", "Unknown name");
            this.description = config.getString("description", "Unknown description");
            this.isPublic = config.getBoolean("public", true);
            if (config.get("icon") != null) {
                try {
                    if (config.isString("icon")) {
                        this.icon = new ItemStack(Material.valueOf((String)config.getString("icon")));
                        break block5;
                    }
                    this.icon = ItemStack.deserialize((Map)config.getConfigurationSection("icon").getValues(true));
                }
                catch (Exception ignored) {
                    this.icon = new ItemStack(Material.BARREL);
                }
            } else {
                this.icon = new ItemStack(Material.BARREL);
            }
        }
        ItemUtils.setPersistentData(this.icon, ItemUtils.getItemIdKey(), String.valueOf(this.module.getId()));
        this.creationTime = config.getLong("creation-time", 1670573410000L);
        this.reputation = config.getStringList("players.liked").size() - config.getStringList("players.disliked").size();
        this.downloads = config.getIntegerList("planets").size();
    }

    public void updateIcon() {
        ItemStack item = this.icon.clone();
        ItemMeta meta = item.getItemMeta();
        meta.displayName(MessageUtils.getLocaleComponent("menus.modules.items.module.name").replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%moduleName%").replacement((ComponentLike)this.displayName()).build()));
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : MessageUtils.getLocaleItemDescription("menus.modules.items.module.lore")) {
            if (loreLine.contains("%moduleDescription%")) {
                String[] newLines;
                for (String newLine : newLines = this.description.split("\\\\n")) {
                    lore.add(loreLine.replace("%moduleDescription%", ChatColor.translateAlternateColorCodes((char)'&', (String)newLine)));
                }
                continue;
            }
            lore.add(MessageUtils.parseModuleLines(this.module, loreLine));
        }
        item.setAmount(1);
        meta.setLore(lore);
        item.setItemMeta(meta);
        ItemUtils.clearItemFlags(item);
        ItemUtils.setPersistentData(item, ItemUtils.getItemIdKey(), String.valueOf(this.module.getId()));
        this.icon = item;
    }

    public void setIcon(ItemStack itemStack) {
        ItemStack newIcon = ItemUtils.clearItemMeta(itemStack.clone());
        newIcon.setAmount(1);
        FileUtils.setModuleConfigParameter(this.module, "icon", newIcon.serialize());
        this.icon = newIcon;
        this.updateIcon();
    }

    public void setPublic(boolean isPublic) {
        if (isPublic == this.isPublic) {
            return;
        }
        this.isPublic = isPublic;
        FileUtils.setModuleConfigParameter(this.module, "public", isPublic);
        this.updateIconAsync();
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        FileUtils.setModuleConfigParameter(this.module, "name", name);
        this.updateIconAsync();
    }

    public void setDescription(String description) {
        this.description = description;
        FileUtils.setModuleConfigParameter(this.module, "description", description);
        this.updateIconAsync();
    }

    public boolean wasDownloadedBefore(@NotNull Planet planet) {
        if (planet == null) {
            ModuleInfo.$$$reportNull$$$0(5);
        }
        FileConfiguration config = FileUtils.getModuleConfig(this.module);
        List planets = config.getIntegerList("planets");
        return planets.contains(planet.getId());
    }

    public void addDownload(@NotNull Planet planet) {
        FileConfiguration config;
        List planets;
        if (planet == null) {
            ModuleInfo.$$$reportNull$$$0(6);
        }
        if ((planets = (config = FileUtils.getModuleConfig(this.module)).getIntegerList("planets")).contains(planet.getId())) {
            return;
        }
        planets.add(planet.getId());
        FileUtils.setModuleConfigParameter(this.module, "planets", planets);
        this.downloads = planets.size();
        this.updateIconAsync();
    }

    public boolean addLike(@NotNull Player player) {
        FileConfiguration config;
        List likedUUIDs;
        if (player == null) {
            ModuleInfo.$$$reportNull$$$0(7);
        }
        if ((likedUUIDs = (config = FileUtils.getModuleConfig(this.module)).getStringList("players.liked")).contains(player.getUniqueId().toString())) {
            return false;
        }
        List dislikedUUIDs = config.getStringList("players.disliked");
        if (dislikedUUIDs.contains(player.getUniqueId().toString())) {
            return false;
        }
        likedUUIDs.add(player.getUniqueId().toString());
        FileUtils.setModuleConfigParameter(this.module, "players.liked", likedUUIDs);
        this.reputation = likedUUIDs.size() - dislikedUUIDs.size();
        this.updateIconAsync();
        return true;
    }

    public boolean addDislike(@NotNull Player player) {
        FileConfiguration config;
        List dislikedUUIDs;
        if (player == null) {
            ModuleInfo.$$$reportNull$$$0(8);
        }
        if ((dislikedUUIDs = (config = FileUtils.getModuleConfig(this.module)).getStringList("players.disliked")).contains(player.getUniqueId().toString())) {
            return false;
        }
        List likedUUIDs = config.getStringList("players.liked");
        if (likedUUIDs.contains(player.getUniqueId().toString())) {
            return false;
        }
        dislikedUUIDs.add(player.getUniqueId().toString());
        FileUtils.setModuleConfigParameter(this.module, "players.disliked", dislikedUUIDs);
        this.reputation = likedUUIDs.size() - dislikedUUIDs.size();
        this.updateIconAsync();
        return true;
    }

    public void updateIconAsync() {
        new BukkitRunnable(){

            public void run() {
                ModuleInfo.this.updateIcon();
            }
        }.runTaskAsynchronously((Plugin)OpenCreative.getPlugin());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/coding/modules/ModuleInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "planet";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/modules/ModuleInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wasDownloadedBefore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDownload";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLike";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDislike";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

