/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.modules;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.listeners.player.ChatListener;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.ConfirmationMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.ParameterButton;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerConfirmation;

public class ModuleSettingsMenu
extends AbstractMenu {
    private final Module module;
    private final Player player;
    private final ItemStack name = ItemUtils.createItem(Material.JUNGLE_SIGN, 1, "menus.module-settings.items.change-name", "name");
    private final ItemStack description = ItemUtils.createItem(Material.WRITABLE_BOOK, 1, "menus.module-settings.items.change-description", "description");
    private final ItemStack install = ItemUtils.createItem(Material.CHERRY_CHEST_BOAT, 1, "menus.module-settings.items.install", "install");
    private final ItemStack delete = ItemUtils.createItem(Material.TNT_MINECART, 1, "menus.module-settings.items.delete", "delete");
    private final ParameterButton access;
    private ItemStack moduleIcon;
    private static final Map<UUID, Integer> settingsSessions = new HashMap<UUID, Integer>();

    public ModuleSettingsMenu(Module module, Player player) {
        super(4, MessageUtils.getLocaleMessage("menus.module-settings.title", false));
        this.module = module;
        this.player = player;
        this.moduleIcon = this.getModuleIcon();
        this.access = new ParameterButton((Object)(module.getInformation().isPublic() ? "public" : "private"), List.of("public", "private"), "access", "menus.module-settings", "menus.module-settings.items.change-sharing", List.of(Material.LIME_DYE, Material.GRAY_DYE));
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(10, this.name);
        this.setItem(11, this.description);
        this.setItem(16, this.access.getItem());
        this.setItem(27, this.install);
        this.setItem(28, this.DECORATION_PANE_ITEM);
        this.setItem(29, ItemUtils.createItem(Material.BROWN_STAINED_GLASS_PANE, 1));
        this.setItem(31, this.moduleIcon);
        this.setItem(33, ItemUtils.createItem(Material.BROWN_STAINED_GLASS_PANE, 1));
        this.setItem(34, this.DECORATION_PANE_ITEM);
        this.setItem(35, this.delete);
    }

    public static void setCurrentEditingModule(@NotNull Player player, @NotNull Module module) {
        if (player == null) {
            ModuleSettingsMenu.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ModuleSettingsMenu.$$$reportNull$$$0(1);
        }
        settingsSessions.put(player.getUniqueId(), module.getId());
    }

    @Nullable
    public static Module getCurrentEditingModule(@NotNull Player player) {
        Integer id;
        if (player == null) {
            ModuleSettingsMenu.$$$reportNull$$$0(2);
        }
        if ((id = settingsSessions.get(player.getUniqueId())) == null) {
            return null;
        }
        Module module = OpenCreative.getModuleManager().getModuleById(String.valueOf(id));
        if (module == null) {
            settingsSessions.values().removeIf(i -> i.equals(id));
            return null;
        }
        return module;
    }

    public static void removeFromCurrentEditing(@NotNull Player player) {
        if (player == null) {
            ModuleSettingsMenu.$$$reportNull$$$0(3);
        }
        settingsSessions.remove(player.getUniqueId());
    }

    public static void removeFromCurrentEditing(@NotNull Module module) {
        if (module == null) {
            ModuleSettingsMenu.$$$reportNull$$$0(4);
        }
        settingsSessions.values().removeIf(i -> i.equals(module.getId()));
    }

    public ItemStack getModuleIcon() {
        ItemStack item = ItemUtils.clearItemMeta(this.module.getInformation().getIcon().clone());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(MessageUtils.getLocaleItemName("menus.module-settings.items.module.name").replace("%moduleName%", this.module.getInformation().getDisplayName()));
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : MessageUtils.getLocaleItemDescription("menus.module-settings.items.module.lore")) {
            if (loreLine.contains("%moduleDescription%")) {
                String[] newLines;
                for (String newLine : newLines = this.module.getInformation().getDescription().split("\\\\n")) {
                    lore.add(loreLine.replace("%moduleDescription%", ChatColor.translateAlternateColorCodes((char)'&', (String)newLine)));
                }
                continue;
            }
            lore.add(MessageUtils.parseModuleLines(this.module, loreLine));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        ItemUtils.clearItemFlags(item);
        return item;
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            ModuleSettingsMenu.$$$reportNull$$$0(5);
        }
        if (!this.isClickedInMenuSlots(event) || !this.isPlayerClicked(event)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        if (ItemUtils.itemEquals(currentItem, this.name)) {
            this.player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.module-name.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.module-name.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofMillis(130L))));
            this.player.sendMessage(MessageUtils.getLocaleMessage("settings.module-name.usage").replace("%player%", this.player.getName()));
            this.player.closeInventory();
            if (!ChatListener.confirmation.containsKey(this.player)) {
                ChatListener.confirmation.put(this.player, PlayerConfirmation.MODULE_NAME_CHANGE);
                ModuleSettingsMenu.setCurrentEditingModule(this.player, this.module);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.description)) {
            this.player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.module-description.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.module-description.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofMillis(130L))));
            this.player.sendMessage(MessageUtils.getLocaleMessage("settings.module-description.usage"));
            this.player.closeInventory();
            if (!ChatListener.confirmation.containsKey(this.player)) {
                ChatListener.confirmation.put(this.player, PlayerConfirmation.MODULE_DESCRIPTION_CHANGE);
                ModuleSettingsMenu.setCurrentEditingModule(this.player, this.module);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.access.getItem())) {
            this.access.next();
            this.setItem(event.getRawSlot(), this.access.getItem());
            if ("public".equals(this.access.getCurrentValue().toString())) {
                this.module.getInformation().setPublic(true);
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.module-sharing.enabled"));
                Sounds.WORLD_SETTINGS_SHARING_PUBLIC.play((Audience)this.player);
            } else {
                this.module.getInformation().setPublic(false);
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.module-sharing.disabled"));
                Sounds.WORLD_SETTINGS_SHARING_PRIVATE.play((Audience)this.player);
            }
            this.moduleIcon = this.getModuleIcon();
            this.setItem(31, this.moduleIcon);
        } else if (ItemUtils.itemEquals(currentItem, this.moduleIcon)) {
            if (event.getCursor().isEmpty()) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.module-icon.error"));
                Sounds.PLAYER_FAIL.play((Audience)this.player);
            } else {
                this.module.getInformation().setIcon(event.getCursor());
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.module-icon.changed"));
                this.moduleIcon = this.getModuleIcon();
                this.setItem(31, this.moduleIcon);
                event.setCursor(null);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.install)) {
            this.player.closeInventory();
            DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(this.player);
            if (devPlanet == null) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                Sounds.PLAYER_FAIL.play((Audience)this.player);
                return;
            }
            if (!devPlanet.getPlanet().getWorldPlayers().canDevelop(this.player)) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("not-developer"));
                Sounds.PLAYER_FAIL.play((Audience)this.player);
                return;
            }
            this.module.place(devPlanet, this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.delete)) {
            this.player.closeInventory();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OpenCreative.getPlugin(), () -> new ConfirmationMenu(MessageUtils.getLocaleMessage("menus.confirmation.delete-module", false).replace("%name%", MessageUtils.substring(ChatColor.stripColor((String)this.module.getInformation().getDisplayName()), 20)), Material.TNT, MessageUtils.getLocaleItemName("menus.confirmation.items.delete-module.name"), MessageUtils.getLocaleItemDescription("menus.confirmation.items.delete-module.lore"), new BukkitRunnable(){

                public void run() {
                    ModuleSettingsMenu.this.player.closeInventory();
                    if (!OpenCreative.getModuleManager().getModules().contains(ModuleSettingsMenu.this.module)) {
                        this.cancel();
                        return;
                    }
                    if (!ModuleSettingsMenu.this.module.isOwner((OfflinePlayer)ModuleSettingsMenu.this.player)) {
                        this.cancel();
                        return;
                    }
                    Sounds.WORLD_DELETION.play((Audience)ModuleSettingsMenu.this.player);
                    OpenCreative.getModuleManager().deleteModule(ModuleSettingsMenu.this.module);
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)OpenCreative.getPlugin(), () -> ModuleSettingsMenu.this.player.sendMessage(MessageUtils.getLocaleMessage("modules.deleted").replace("%moduleID%", String.valueOf(ModuleSettingsMenu.this.module.getId()))), 60L);
                }
            }).open(this.player), 5L);
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            ModuleSettingsMenu.$$$reportNull$$$0(6);
        }
        if (!this.module.isOwner((OfflinePlayer)this.player)) {
            event.setCancelled(true);
            return;
        }
        Sounds.MENU_OPEN_MODULE_SETTINGS.play((Audience)this.player);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/modules/ModuleSettingsMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentEditingModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentEditingModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeFromCurrentEditing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

