/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.modules;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.coding.modules.OwnModulesBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ModulesBrowserMenu
extends ListBrowserMenu<Module> {
    private final List<Module> modules = new ArrayList<Module>();

    public ModulesBrowserMenu(Player player, List<Module> modules) {
        super(player, MessageUtils.getLocaleMessage("menus.modules.title", false), ListBrowserMenu.PlacementLayout.BOTTOM_NO_DECORATION, new int[]{49}, new int[]{45, 46, 52, 53});
        this.modules.addAll(modules);
    }

    public ModulesBrowserMenu(Player player) {
        this(player, new ArrayList<Module>(OpenCreative.getModuleManager().getModules()));
    }

    @Override
    protected ItemStack getElementIcon(Module module) {
        return module.getInformation().getIcon();
    }

    @Override
    protected void fillOtherItems() {
        this.setItem(ItemUtils.createItem(Material.BROWN_STAINED_GLASS_PANE, 1), 47, 51);
        this.setItem(ItemUtils.createItem(Material.CHEST_MINECART, 1, "menus.modules.items.own-modules", "own-modules"), 49);
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
        ItemStack currentItem = event.getCurrentItem();
        event.setCancelled(true);
        if (currentItem == null) {
            return;
        }
        if (ItemUtils.getItemType(currentItem).equalsIgnoreCase("own-modules")) {
            new OwnModulesBrowserMenu(this.getPlayer()).open(this.getPlayer());
        }
    }

    @Override
    protected void fillArrowsItems(int currentPage) {
        if (this.elements.isEmpty()) {
            this.setItem(this.getNoElementsPageButtonSlot(), this.getNoElementsButton());
            this.setItem(this.getPreviousPageButtonSlot(), this.DECORATION_ITEM);
            this.setItem(this.getNextPageButtonSlot(), this.DECORATION_ITEM);
        } else {
            int maxPagesAmount = this.getPages();
            if (currentPage > maxPagesAmount || currentPage < 1) {
                currentPage = 1;
            }
            this.setItem(this.getPreviousPageButtonSlot(), currentPage > 1 ? this.getPreviousPageButton() : this.DECORATION_ITEM);
            this.setItem(this.getNextPageButtonSlot(), currentPage < maxPagesAmount ? this.getNextPageButton() : this.DECORATION_ITEM);
        }
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack currentItem = event.getCurrentItem();
        event.setCancelled(true);
        if (currentItem == null) {
            return;
        }
        String id = ItemUtils.getPersistentData(currentItem, ItemUtils.getItemIdKey());
        if (id.isEmpty()) {
            return;
        }
        Module module = OpenCreative.getModuleManager().getModuleById(id);
        if (module == null) {
            return;
        }
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(this.getPlayer());
        event.getWhoClicked().closeInventory();
        if (devPlanet == null) {
            this.getPlayer().sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
            Sounds.PLAYER_FAIL.play((Audience)event.getWhoClicked());
            return;
        }
        module.place(devPlanet, this.getPlayer());
    }

    @Override
    public List<Module> getElements() {
        return this.modules;
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, this.getCurrentPage() + 1, "menus.modules.items.next-page"), "%page%", this.getCurrentPage() + 1);
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.ARROW, this.getCurrentPage() + 1, "menus.modules.items.previous-page"), "%page%", this.getCurrentPage() - 1);
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.BARRIER, 1, "menus.modules.items.no-modules");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            ModulesBrowserMenu.$$$reportNull$$$0(0);
        }
        Sounds.MENU_OPEN_MODULES_BROWSER.play((Audience)event.getPlayer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/coding/modules/ModulesBrowserMenu", "onOpen"));
    }
}

