/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.MobInteractionEvent;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyPlaceholder;

public class EntityPlaceholder
extends KeyPlaceholder {
    public EntityPlaceholder() {
        super("entity", "entity_uuid");
    }

    @Override
    @Nullable
    public String parseKey(String key, ActionsHandler handler, Action action) {
        switch (key) {
            case "entity": {
                WorldEvent worldEvent = handler.getEvent();
                if (worldEvent instanceof MobInteractionEvent) {
                    MobInteractionEvent event = (MobInteractionEvent)worldEvent;
                    return event.getEntity().getName();
                }
                worldEvent = handler.getEvent().getSelection().getFirst();
                if (!(worldEvent instanceof Entity)) break;
                Entity entity = (Entity)worldEvent;
                return entity.getName();
            }
            case "entity_uuid": {
                WorldEvent worldEvent = handler.getEvent();
                if (worldEvent instanceof MobInteractionEvent) {
                    MobInteractionEvent event = (MobInteractionEvent)worldEvent;
                    return event.getEntity().getUniqueId().toString();
                }
                worldEvent = handler.getEvent().getSelection().getFirst();
                if (!(worldEvent instanceof Entity)) break;
                Entity entity = (Entity)worldEvent;
                return entity.getUniqueId().toString();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "Entity Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses entity placeholders";
    }
}

