/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.EntityPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.EventPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.ListPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.Placeholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.PlanetPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.PlayerPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.RandomPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.SymbolPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.TargetPlaceholder;
import ua.mcchickenstudio.opencreative.coding.placeholders.VarPlaceholder;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public class Placeholders {
    private static Placeholders instance;
    private final List<Placeholder> placeholders = new ArrayList<Placeholder>();

    @NotNull
    public static synchronized Placeholders getInstance() {
        if (instance == null) {
            instance = new Placeholders();
            instance.registerPlaceholder(new SymbolPlaceholder());
            instance.registerPlaceholder(new PlayerPlaceholder());
            instance.registerPlaceholder(new TargetPlaceholder());
            instance.registerPlaceholder(new EntityPlaceholder());
            instance.registerPlaceholder(new RandomPlaceholder());
            instance.registerPlaceholder(new EventPlaceholder());
            instance.registerPlaceholder(new PlanetPlaceholder());
            instance.registerPlaceholder(new VarPlaceholder());
            instance.registerPlaceholder(new ListPlaceholder());
        }
        Placeholders placeholders = instance;
        if (placeholders == null) {
            Placeholders.$$$reportNull$$$0(0);
        }
        return placeholders;
    }

    public void registerPlaceholder(@NotNull Placeholder placeholder) {
        if (placeholder == null) {
            Placeholders.$$$reportNull$$$0(1);
        }
        if (placeholder instanceof KeyPlaceholder) {
            KeyPlaceholder key = (KeyPlaceholder)placeholder;
            if (key.getKeys().length == 0) {
                ErrorUtils.sendWarningErrorMessage("[PLACEHOLDERS] " + String.valueOf(placeholder) + " will be not registered, because has 0 keys.");
                return;
            }
            for (Placeholder listedPlaceholder : this.placeholders) {
                if (!(listedPlaceholder instanceof KeyPlaceholder)) continue;
                KeyPlaceholder key2 = (KeyPlaceholder)listedPlaceholder;
                Set<String> sameKeys = this.getSameKeys(key, key2);
                if (sameKeys.isEmpty()) break;
                ErrorUtils.sendWarningErrorMessage("[PLACEHOLDERS] Same placeholders keys conflict " + String.valueOf(key) + ", " + String.valueOf(key2) + " in: " + String.join((CharSequence)", ", sameKeys));
            }
        }
        ErrorUtils.sendDebug("[PLACEHOLDERS] Registered " + String.valueOf(placeholder));
        this.placeholders.add(placeholder);
    }

    public void unregisterPlaceholder(@NotNull Placeholder placeholder) {
        if (placeholder == null) {
            Placeholders.$$$reportNull$$$0(2);
        }
        this.placeholders.remove(placeholder);
    }

    @NotNull
    public List<Placeholder> getPlaceholders() {
        return new ArrayList<Placeholder>(this.placeholders);
    }

    @NotNull
    private Set<String> getSameKeys(@NotNull KeyPlaceholder first, @NotNull KeyPlaceholder second) {
        if (first == null) {
            Placeholders.$$$reportNull$$$0(3);
        }
        if (second == null) {
            Placeholders.$$$reportNull$$$0(4);
        }
        HashSet<String> sameKeys = new HashSet<String>();
        for (String key : first.getKeys()) {
            if (!Arrays.asList(second.getKeys()).contains(key)) continue;
            sameKeys.add(key);
        }
        HashSet<String> hashSet = sameKeys;
        if (hashSet == null) {
            Placeholders.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    public String parsePlaceholders(String text, ActionsHandler handler, Action action) {
        text = text.replace("\\n", "\n");
        try {
            for (Placeholder placeholder : this.placeholders) {
                if (!placeholder.matches(text)) continue;
                text = placeholder.parse(text, handler, action);
            }
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("[PLACEHOLDERS] Can't parse placeholder", error);
        }
        String string = text;
        if (string == null) {
            Placeholders.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/coding/placeholders/Placeholders";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/placeholders/Placeholders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePlaceholders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerPlaceholder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unregisterPlaceholder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSameKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

