/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyPlaceholder;
import ua.mcchickenstudio.opencreative.planets.Planet;

public class PlanetPlaceholder
extends KeyPlaceholder {
    public PlanetPlaceholder() {
        super("online", "players_amount", "entities_amount");
    }

    @Override
    @Nullable
    public String parseKey(String key, ActionsHandler handler, Action action) {
        Planet planet = handler.getExecutor().getPlanet();
        return switch (key) {
            case "online" -> String.valueOf(Bukkit.getOnlinePlayers().size());
            case "players_amount" -> String.valueOf(planet.getPlayers().size());
            case "entities_amount" -> String.valueOf(planet.getTerritory().getWorld().getEntityCount() + (planet.getDevPlanet() != null && planet.getDevPlanet().getWorld() != null ? planet.getDevPlanet().getWorld().getEntityCount() : 0));
            default -> null;
        };
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "Planet Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses planet placeholders";
    }
}

