/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyPlaceholder;

public class PlayerPlaceholder
extends KeyPlaceholder {
    public PlayerPlaceholder() {
        super("player", "player_uuid", "display_name");
    }

    @Override
    @Nullable
    public String parseKey(String key, ActionsHandler handler, Action action) {
        Object object = handler.getEvent().getSelection().getFirst();
        if (object instanceof Player) {
            Player player = (Player)object;
            switch (key) {
                case "player": {
                    return player.getName();
                }
                case "player_uuid": {
                    return player.getUniqueId().toString();
                }
                case "display_name": {
                    return player.getDisplayName();
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "Player Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses player placeholders";
    }
}

