/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import java.util.List;
import java.util.Random;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyPlaceholder;

public class RandomPlaceholder
extends KeyPlaceholder {
    public RandomPlaceholder() {
        super("random", "random_uuid");
    }

    @Override
    @Nullable
    public String parseKey(String key, ActionsHandler handler, Action action) {
        Player randomPlayer = null;
        List playerList = handler.getExecutor().getPlanet().getTerritory().getWorld().getPlayers();
        if (playerList.isEmpty()) {
            return null;
        }
        Random r = new Random();
        int i = r.nextInt(playerList.size());
        randomPlayer = (Player)playerList.get(i);
        if (randomPlayer != null) {
            if (key.equals("random")) {
                return randomPlayer.getName();
            }
            if (key.equals("random_uuid")) {
                return randomPlayer.getUniqueId().toString();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "Random Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses random placeholders";
    }
}

