/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyPlaceholder;

public class TargetPlaceholder
extends KeyPlaceholder {
    public TargetPlaceholder() {
        super("selected", "selected_uuid", "target", "target_uuid", "targets", "selection");
    }

    @Override
    @Nullable
    public String parseKey(String key, ActionsHandler handler, Action action) {
        Entity entity = action.getEntity();
        return switch (key) {
            case "selected", "target" -> {
                if (entity == null) {
                    yield null;
                }
                yield entity.getName();
            }
            case "selected_uuid", "target_uuid" -> {
                if (entity == null) {
                    yield null;
                }
                yield entity.getUniqueId().toString();
            }
            case "targets", "selection" -> String.join((CharSequence)", ", action.getHandler().getSelectedTargets().stream().map(CommandSender::getName).toList());
            default -> null;
        };
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "Target Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses target placeholders";
    }
}

