/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class EditCommand
extends CommandHandler {
    private static final int TEXT_LIMIT = 100;
    private static final int LINES_LIMIT = 20;

    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            EditCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            EditCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            EditCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            OpenCreative.getPlugin().getLogger().info(MessageUtils.getLocaleMessage("only-in-world"));
            return;
        }
        Player player = (Player)sender;
        if (!this.checkPermissions(player)) {
            return;
        }
        if (args.length == 0) {
            sender.sendMessage(MessageUtils.getLocaleMessage("commands.edit.help"));
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        if (item.getType().isAir() || meta == null) {
            sender.sendMessage(MessageUtils.getLocaleMessage("commands.edit.item"));
            return;
        }
        switch (args[0].toLowerCase()) {
            case "name": {
                this.handleSetName(player, item, args);
                break;
            }
            case "lore": 
            case "setlore": {
                this.handleSetLore(player, item, args);
                break;
            }
            case "addlore": {
                this.handleAddLore(player, item, args);
                break;
            }
            case "removelore": 
            case "deletelore": 
            case "dellore": 
            case "remlore": {
                this.handleRemoveLore(player, item, args);
                break;
            }
            case "clear": {
                this.handleClear(player, item);
            }
        }
    }

    private boolean checkPermissions(Player player) {
        if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
            return false;
        }
        if (player.hasPermission("opencreative.edit.bypass")) {
            return true;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
            return false;
        }
        if (!(planet.isOwner(player) || planet.getWorldPlayers().canDevelop(player) || planet.getWorldPlayers().canBuild(player))) {
            player.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
            return false;
        }
        return true;
    }

    private String joinArgs(String[] args, int fromIndex) {
        return String.join((CharSequence)" ", Arrays.copyOfRange(args, fromIndex, args.length));
    }

    private void handleSetName(Player player, ItemStack item, String[] args) {
        ItemMeta meta = item.getItemMeta();
        if (args.length == 1) {
            if (!meta.hasDisplayName()) {
                player.sendMessage(MessageUtils.getLocaleMessage("commands.edit.item"));
                return;
            }
            player.sendMessage(meta.displayName().clickEvent(ClickEvent.suggestCommand((String)meta.getDisplayName())));
        } else {
            String newName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.joinArgs(args, 1));
            if (ChatColor.stripColor((String)newName).length() >= 100) {
                player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.text-limit").replace("%limit%", String.valueOf(100))));
                return;
            }
            meta.setDisplayName(newName);
            item.setItemMeta(meta);
            player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.renamed").replace("%name%", newName)).clickEvent(ClickEvent.suggestCommand((String)newName)));
        }
    }

    private void handleSetLore(Player player, ItemStack item, String[] args) {
        List<String> newLore;
        ItemMeta meta = item.getItemMeta();
        if (args.length == 1) {
            player.sendMessage(MessageUtils.getLocaleMessage("commands.edit.item"));
            return;
        }
        int lineNumber = 1;
        try {
            lineNumber = Integer.parseInt(args[1]);
            if (lineNumber < 1) {
                lineNumber = 1;
            } else if (lineNumber >= 20) {
                player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.lines-limit").replace("%limit%", String.valueOf(20))));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String newLoreLine = ChatColor.translateAlternateColorCodes((char)'&', (String)this.joinArgs(args, 1));
        if (ChatColor.stripColor((String)newLoreLine).length() >= 100) {
            player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.text-limit").replace("%limit%", String.valueOf(100))));
            return;
        }
        List list = newLore = meta.getLore() == null ? new ArrayList() : meta.getLore();
        if (newLore.size() < lineNumber) {
            while (newLore.size() < lineNumber) {
                newLore.add(" ");
            }
        }
        if (args.length == 2) {
            player.sendMessage(Component.text((String)((String)newLore.get(lineNumber - 1))).clickEvent(ClickEvent.suggestCommand((String)((String)newLore.get(lineNumber - 1)))));
            return;
        }
        newLore.set(lineNumber - 1, newLoreLine);
        meta.setLore(newLore);
        item.setItemMeta(meta);
        player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.set-lore").replace("%number%", String.valueOf(lineNumber)).replace("%lore%", newLoreLine)).clickEvent(ClickEvent.suggestCommand((String)newLoreLine)));
    }

    private void handleAddLore(Player player, ItemStack item, String[] args) {
        List<String> newLore;
        ItemMeta meta = item.getItemMeta();
        String newLoreLine = ChatColor.translateAlternateColorCodes((char)'&', (String)this.joinArgs(args, 1));
        if (ChatColor.stripColor((String)newLoreLine).length() >= 100) {
            player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.text-limit").replace("%limit%", String.valueOf(100))));
            return;
        }
        List list = newLore = meta.getLore() == null ? new ArrayList() : meta.getLore();
        if (newLore.size() >= 20) {
            player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.lines-limit").replace("%limit%", String.valueOf(20))));
            return;
        }
        newLore.add(newLoreLine);
        meta.setLore(newLore);
        item.setItemMeta(meta);
        player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.set-lore").replace("%number%", String.valueOf(newLore.size())).replace("%lore%", newLoreLine)).clickEvent(ClickEvent.suggestCommand((String)newLoreLine)));
    }

    private void handleRemoveLore(Player player, ItemStack item, String[] args) {
        List newLore;
        ItemMeta meta = item.getItemMeta();
        if (args.length == 1) {
            player.sendMessage(MessageUtils.getLocaleMessage("commands.edit.item"));
            return;
        }
        int lineNumber = 1;
        try {
            lineNumber = Integer.parseInt(args[1]);
            if (lineNumber < 1) {
                lineNumber = 1;
            } else if (lineNumber >= 20) {
                player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.lines-limit").replace("%limit%", String.valueOf(20))));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List list = newLore = meta.getLore() == null ? new ArrayList() : meta.getLore();
        if (newLore.size() >= lineNumber) {
            newLore.remove(lineNumber - 1);
        }
        meta.setLore(newLore);
        item.setItemMeta(meta);
        player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.removed-lore").replace("%number%", String.valueOf(lineNumber))));
    }

    private void handleClear(Player player, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.displayName(null);
        meta.lore(null);
        item.setItemMeta(meta);
        player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("commands.edit.cleared")));
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            EditCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            EditCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            EditCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            EditCommand.$$$reportNull$$$0(6);
        }
        ArrayList<String> tabCompleter = new ArrayList<String>();
        if (args.length <= 1) {
            tabCompleter.add("name");
            tabCompleter.add("lore");
            tabCompleter.add("addlore");
            tabCompleter.add("removelore");
            tabCompleter.add("clear");
        }
        return tabCompleter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/EditCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

