/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.coding.modules.ModulesBrowserMenu;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ModuleCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            ModuleCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ModuleCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            ModuleCommand.$$$reportNull$$$0(2);
        }
        if (args == null) {
            ModuleCommand.$$$reportNull$$$0(3);
        }
        Player player = null;
        DevPlanet devPlanet = null;
        if (sender instanceof Player) {
            Player senderPlayer = (Player)sender;
            player = senderPlayer;
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        }
        if (args.length == 0) {
            if (player != null) {
                if (devPlanet == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                    return;
                }
                new ModulesBrowserMenu(player).open(player);
            } else {
                sender.sendMessage(MessageUtils.getLocaleMessage("only-players"));
            }
            return;
        }
        switch (args[0].toLowerCase()) {
            case "load": {
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (!this.canUseCommand(sender, player, devPlanet)) {
                    return;
                }
                if (devPlanet == null) {
                    return;
                }
                Module module = OpenCreative.getModuleManager().getModuleById(args[1]);
                if (module == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.not-found").replace("%id%", args[1]));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                module.place(devPlanet, player);
                break;
            }
            case "info": {
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                Module module = OpenCreative.getModuleManager().getModuleById(args[1]);
                if (module == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.not-found").replace("%id%", args[1]));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                sender.sendMessage(MessageUtils.parseModuleLines(module, MessageUtils.getLocaleMessage("modules.info")));
                break;
            }
            case "delete": {
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (!sender.hasPermission("opencreative.modules.delete")) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                    return;
                }
                Module module = OpenCreative.getModuleManager().getModuleById(args[1]);
                if (module == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.not-found").replace("%id%", args[1]));
                    return;
                }
                sender.sendMessage(MessageUtils.getLocaleMessage("modules.deleted").replace("%id%", String.valueOf(module.getId())));
                OpenCreative.getModuleManager().deleteModule(module);
                break;
            }
            case "list": {
                if (!sender.hasPermission("opencreative.modules.list")) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                    return;
                }
                Set<Module> modules = OpenCreative.getModuleManager().getModules();
                sender.sendMessage(MessageUtils.getLocaleMessage("modules.list.amount").replace("%amount%", String.valueOf(modules.size())));
                for (Module module : modules) {
                    sender.sendMessage(MessageUtils.parseModuleLines(module, MessageUtils.getLocaleMessage("modules.list.module")));
                }
                break;
            }
            case "like": {
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (!this.canUseCommand(sender, player, devPlanet)) {
                    return;
                }
                if (devPlanet == null) {
                    return;
                }
                Module module = OpenCreative.getModuleManager().getModuleById(args[1]);
                if (module == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.not-found").replace("%id%", args[1]));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                if (!module.getInformation().wasDownloadedBefore(devPlanet.getPlanet())) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.rating.not-installed"));
                    return;
                }
                if (module.getInformation().addLike(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.rating.liked"));
                    Sounds.DEV_MODULE_LIKED.play((Audience)player);
                    break;
                }
                sender.sendMessage(MessageUtils.getLocaleMessage("modules.rating.already-rated"));
                Sounds.PLAYER_FAIL.play((Audience)player);
                break;
            }
            case "dislike": {
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (!this.canUseCommand(sender, player, devPlanet)) {
                    return;
                }
                if (devPlanet == null) {
                    return;
                }
                Module module = OpenCreative.getModuleManager().getModuleById(args[1]);
                if (module == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.not-found").replace("%id%", args[1]));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                if (!module.getInformation().wasDownloadedBefore(devPlanet.getPlanet())) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.rating.not-installed"));
                    return;
                }
                if (module.getInformation().addDislike(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("modules.rating.disliked"));
                    Sounds.DEV_MODULE_LIKED.play((Audience)player);
                    break;
                }
                sender.sendMessage(MessageUtils.getLocaleMessage("modules.rating.already-rated"));
                Sounds.PLAYER_FAIL.play((Audience)player);
                break;
            }
            default: {
                sender.sendMessage(MessageUtils.getLocaleMessage("modules.help"));
            }
        }
    }

    private boolean canUseCommand(@NotNull CommandSender sender, @Nullable Player player, @Nullable DevPlanet devPlanet) {
        if (sender == null) {
            ModuleCommand.$$$reportNull$$$0(4);
        }
        if (player == null) {
            sender.sendMessage(MessageUtils.getLocaleMessage("only-players"));
            return false;
        }
        if (devPlanet == null) {
            player.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
            return false;
        }
        if (!devPlanet.getPlanet().getWorldPlayers().canDevelop(player)) {
            player.sendMessage(MessageUtils.getLocaleMessage("not-developer"));
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            ModuleCommand.$$$reportNull$$$0(5);
        }
        if (command == null) {
            ModuleCommand.$$$reportNull$$$0(6);
        }
        if (label == null) {
            ModuleCommand.$$$reportNull$$$0(7);
        }
        if (args == null) {
            ModuleCommand.$$$reportNull$$$0(8);
        }
        if (!(sender instanceof Player)) {
            if (args.length == 1) {
                return List.of("delete", "list", "info");
            }
            if (args.length == 2 && List.of("delete", "info", "load", "like", "dislike").contains(args[0].toLowerCase())) {
                return OpenCreative.getModuleManager().getModules().stream().map(module -> String.valueOf(module.getId())).toList();
            }
            return null;
        }
        Player player = (Player)sender;
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            suggestions.add("info");
            suggestions.add("like");
            suggestions.add("dislike");
            if (devPlanet != null) {
                suggestions.add("load");
            }
            if (player.hasPermission("opencreative.modules.delete")) {
                suggestions.add("delete");
            }
            if (player.hasPermission("opencreative.modules.list")) {
                suggestions.add("list");
            }
        } else if (args.length == 2 && (player.hasPermission("opencreative.modules.delete") && args[0].equalsIgnoreCase("delete") || devPlanet != null && List.of("like", "dislike", "load").contains(args[0].toLowerCase()))) {
            return OpenCreative.getModuleManager().getModules().stream().map(module -> String.valueOf(module.getId())).toList();
        }
        return suggestions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/ModuleCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseCommand";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

