/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.values.EventValue;
import ua.mcchickenstudio.opencreative.coding.values.EventValues;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.listeners.player.InteractListener;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ValueCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            ValueCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ValueCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            ValueCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.getLocaleMessage("only-players"));
            return;
        }
        Player player = (Player)sender;
        if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
            return;
        }
        DevPlanet planet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        if (planet == null) {
            player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
            return;
        }
        ItemStack itemStack = null;
        switch (label.toLowerCase()) {
            case "text": {
                itemStack = ItemUtils.createItem(Material.BOOK, 1, "menus.developer.variables.items.text");
                if (args.length == 0) break;
                ItemUtils.setDisplayName(itemStack, ChatColor.translateAlternateColorCodes((char)'&', (String)String.join((CharSequence)" ", args)));
                break;
            }
            case "num": 
            case "number": {
                itemStack = ItemUtils.createItem(Material.SLIME_BALL, 1, "menus.developer.variables.items.number");
                if (args.length <= 0) break;
                double number = 0.0;
                try {
                    number = Double.parseDouble(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (args[0].equalsIgnoreCase("p") || args[0].equalsIgnoreCase("pi")) {
                    number = 3.1415926;
                }
                ItemUtils.setDisplayName(itemStack, "\u00a7a" + number);
                break;
            }
            case "loc": 
            case "location": {
                itemStack = ItemUtils.createItem(Material.PAPER, 1, "menus.developer.variables.items.location");
                try {
                    Location location;
                    World world;
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    float yaw = 0.0f;
                    float pitch = 0.0f;
                    if (args.length >= 3) {
                        x = Double.parseDouble(args[0]);
                        y = Double.parseDouble(args[1]);
                        z = Double.parseDouble(args[2]);
                    }
                    if (args.length >= 5) {
                        yaw = Float.parseFloat(args[3]);
                        pitch = Float.parseFloat(args[4]);
                    }
                    if ((world = planet.getPlanet().getWorld()) == null || BlockUtils.isOutOfBorders(location = new Location(world, x, y, z, yaw, pitch))) break;
                    ItemUtils.setDisplayName(itemStack, InteractListener.formatLocation(location));
                }
                catch (Exception x) {}
                break;
            }
            case "vector": {
                itemStack = ItemUtils.createItem(Material.PRISMARINE_SHARD, 1, "menus.developer.variables.items.vector");
                try {
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    if (args.length >= 3) {
                        x = Double.parseDouble(args[0]);
                        y = Double.parseDouble(args[1]);
                        z = Double.parseDouble(args[2]);
                    }
                    ItemUtils.setDisplayName(itemStack, "\u00a7b" + x + " " + y + " " + z);
                }
                catch (Exception x) {}
                break;
            }
            case "bool": 
            case "boolean": {
                itemStack = ItemUtils.createItem(Material.CLOCK, 1, "menus.developer.variables.items.boolean");
                if (args.length <= 0) break;
                boolean value = Boolean.parseBoolean(args[0]);
                ItemUtils.setDisplayName(itemStack, (value ? "\u00a7a" : "\u00a7c") + value);
                break;
            }
            case "value": 
            case "eventvalue": 
            case "gamevalue": 
            case "worldvalue": {
                itemStack = ItemUtils.createItem(Material.NAME_TAG, 1, "menus.developer.variables.items.event-value");
                if (args.length <= 0) break;
                try {
                    EventValue value = EventValues.getInstance().getById(args[0]);
                    if (value == null) {
                        return;
                    }
                    ItemUtils.setDisplayName(itemStack, value.getLocaleName());
                    ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingVariableTypeKey(), args[0].toUpperCase());
                }
                catch (Exception value) {}
                break;
            }
            case "var": 
            case "variable": {
                VariableLink.VariableType type;
                itemStack = ItemUtils.createItem(Material.MAGMA_CREAM, 1, "menus.developer.variables.items.variable");
                if (args.length <= 0 || (type = VariableLink.VariableType.getEnum(args[0])) == null) break;
                ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingVariableTypeKey(), type.name());
                if (args.length <= 1) break;
                ItemUtils.setDisplayName(itemStack, (type == VariableLink.VariableType.SAVED ? "\u00a7a" : (type == VariableLink.VariableType.GLOBAL ? "\u00a7e" : "\u00a7c")) + String.join((CharSequence)" ", Arrays.stream(args).toList().subList(1, args.length)));
            }
        }
        if (itemStack != null) {
            ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingValueKey(), ValueType.getByMaterial(itemStack.getType()).name());
            Sounds.DEV_TAKE_VALUE.play((Audience)player);
            player.getInventory().addItem(new ItemStack[]{itemStack});
        }
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            ValueCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            ValueCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            ValueCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            ValueCommand.$$$reportNull$$$0(6);
        }
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return null;
        }
        if (!planet.getWorldPlayers().canDevelop(player)) {
            return null;
        }
        ArrayList<String> completer = new ArrayList<String>();
        switch (label.toLowerCase()) {
            case "number": 
            case "num": {
                if (args.length != 1) {
                    return null;
                }
                completer.addAll(List.of("1", "100", "50", "25"));
                break;
            }
            case "boolean": 
            case "bool": {
                if (args.length != 1) {
                    return null;
                }
                completer.addAll(List.of("true", "false"));
                break;
            }
            case "variable": 
            case "var": {
                if (args.length != 1) break;
                completer.addAll(List.of("global", "saved", "local"));
                break;
            }
            case "eventvalue": 
            case "gamevalue": 
            case "worldvalue": 
            case "value": {
                if (args.length != 1) {
                    return null;
                }
                completer.addAll(EventValues.getInstance().getEventValues().stream().map(EventValue::getID).filter(name -> name.startsWith(args[0])).toList());
            }
        }
        return completer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/ValueCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

