/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.minecraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class GamemodeCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            GamemodeCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GamemodeCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            GamemodeCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            Bukkit.getServer().dispatchCommand(sender, "minecraft:gamemode " + String.join((CharSequence)" ", args));
            return;
        }
        Player player = (Player)sender;
        if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
            return;
        }
        if (!player.hasPermission("opencreative.game-mode.bypass")) {
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            if (planet == null) {
                player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                return;
            }
            if (!(planet.isOwner(player) || planet.getWorldPlayers().canDevelop(player) || planet.getWorldPlayers().canBuild(player))) {
                player.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                return;
            }
            if (OpenCreative.getPlanetsManager().getDevPlanet(player) != null) {
                player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                return;
            }
        }
        if (args.length == 1) {
            mode = null;
            switch (args[0]) {
                case "0": {
                    mode = GameMode.SURVIVAL;
                    break;
                }
                case "1": {
                    mode = GameMode.CREATIVE;
                    break;
                }
                case "2": {
                    mode = GameMode.ADVENTURE;
                    break;
                }
                case "3": {
                    mode = GameMode.SPECTATOR;
                }
            }
            try {
                if (mode == null) {
                    mode = GameMode.valueOf((String)args[0].toUpperCase());
                }
                player.setGameMode(mode);
            }
            catch (IllegalArgumentException error) {
                player.sendMessage(MessageUtils.getLocaleMessage("commands.game-mode.wrong"));
            }
        } else if (args.length == 2) {
            mode = null;
            switch (args[0]) {
                case "0": {
                    mode = GameMode.SURVIVAL;
                    break;
                }
                case "1": {
                    mode = GameMode.CREATIVE;
                    break;
                }
                case "2": {
                    mode = GameMode.ADVENTURE;
                    break;
                }
                case "3": {
                    mode = GameMode.SPECTATOR;
                }
            }
            try {
                Player modePlayer;
                if (mode == null) {
                    mode = GameMode.valueOf((String)args[0].toUpperCase());
                }
                if ((modePlayer = Bukkit.getPlayer((String)args[1])) == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
                Planet modePlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(modePlayer);
                if (!player.hasPermission("opencreative.game-mode.bypass")) {
                    Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                    if (planet == null || !planet.equals(modePlanet)) {
                        player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                        return;
                    }
                    if (OpenCreative.getPlanetsManager().getDevPlanet(modePlayer) != null) {
                        player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                        return;
                    }
                }
                modePlayer.setGameMode(mode);
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(MessageUtils.getLocaleMessage("commands.game-mode.wrong"));
            }
        } else {
            sender.sendMessage(MessageUtils.getLocaleMessage("commands.game-mode.help"));
            return;
        }
    }

    @Override
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            GamemodeCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            GamemodeCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            GamemodeCommand.$$$reportNull$$$0(5);
        }
        if (args.length >= 3) {
            return null;
        }
        ArrayList<String> tabCompleter = new ArrayList<String>();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                tabCompleter.addAll(Arrays.stream(GameMode.values()).map(gameMode -> gameMode.name().toLowerCase()).toList());
            } else if (args.length == 2) {
                tabCompleter.addAll(player.getWorld().getPlayers().stream().map(Player::getName).toList());
            }
        }
        return tabCompleter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/minecraft/GamemodeCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

