/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.minecraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class GiveCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            GiveCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GiveCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            GiveCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            Bukkit.getServer().dispatchCommand(sender, "minecraft:give " + String.join((CharSequence)" ", args));
        } else {
            Player player = (Player)sender;
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            if (!player.hasPermission("opencreative.give.bypass")) {
                Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                if (planet == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                    return;
                }
                if (!(planet.isOwner(player) || planet.getWorldPlayers().canDevelop(player) || planet.getWorldPlayers().canBuild(player))) {
                    player.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
            }
            if (args.length == 0) {
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.give.help"));
                return;
            }
            if (args.length == 1) {
                try {
                    material = Material.valueOf((String)args[0].replace("minecraft:", "").toUpperCase());
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(material)});
                }
                catch (IllegalArgumentException error) {
                    player.sendMessage(MessageUtils.getLocaleMessage("commands.give.wrong"));
                }
            } else if (args.length == 2) {
                Planet planet;
                Player givePlayer = Bukkit.getPlayer((String)args[0]);
                if (givePlayer == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
                Planet givePlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(givePlayer);
                if (!(player.hasPermission("opencreative.give.bypass") || (planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) != null && planet.equals(givePlanet))) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
                try {
                    material = Material.valueOf((String)args[1].replace("minecraft:", "").toUpperCase());
                    givePlayer.getInventory().addItem(new ItemStack[]{new ItemStack(material)});
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(MessageUtils.getLocaleMessage("commands.give.wrong"));
                }
            } else if (args.length == 3) {
                try {
                    Player givePlayer = Bukkit.getPlayer((String)args[0]);
                    if (givePlayer == null) {
                        player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                        return;
                    }
                    Material material = Material.valueOf((String)args[1].replace("minecraft:", "").toUpperCase());
                    int amount = Integer.parseInt(args[2]);
                    ItemStack item = new ItemStack(material, amount);
                    givePlayer.getInventory().addItem(new ItemStack[]{item});
                }
                catch (NumberFormatException error) {
                    player.sendMessage(MessageUtils.getLocaleMessage("commands.give.wrong-amount"));
                }
                catch (IllegalArgumentException error) {
                    player.sendMessage(MessageUtils.getLocaleMessage("commands.give.wrong"));
                }
            }
        }
    }

    @Override
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            GiveCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            GiveCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            GiveCommand.$$$reportNull$$$0(5);
        }
        ArrayList<String> tabCompleter = new ArrayList<String>();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                tabCompleter.addAll(player.getWorld().getPlayers().stream().map(Player::getName).toList());
            } else if (args.length == 2) {
                tabCompleter.addAll(Arrays.stream(Material.values()).filter(Material::isItem).map(material -> material.name().toLowerCase()).toList());
            } else if (args.length == 3) {
                tabCompleter.add("1");
                tabCompleter.add("16");
                tabCompleter.add("32");
                tabCompleter.add("64");
            } else {
                return null;
            }
        }
        return tabCompleter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/minecraft/GiveCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

