/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.minecraft;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class PlaySoundCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            PlaySoundCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            PlaySoundCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            PlaySoundCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            Bukkit.getServer().dispatchCommand(sender, "minecraft:playsound " + String.join((CharSequence)" ", args));
        } else {
            String soundString;
            Player player = (Player)sender;
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            if (!player.hasPermission("opencreative.play-sound.bypass")) {
                Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                if (planet == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                    return;
                }
                if (!planet.isOwner(player) && !planet.getWorldPlayers().canDevelop(player)) {
                    player.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
            }
            if (args.length == 0) {
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.play-sound.help"));
                return;
            }
            Player target = player;
            Sound sound = null;
            float volume = 100.0f;
            float pitch = 1.0f;
            Long seed = null;
            boolean isCustomTarget = false;
            if (args.length >= 2) {
                try {
                    volume = Float.parseFloat(args[1]);
                }
                catch (NumberFormatException ignored) {
                    isCustomTarget = true;
                }
                if (isCustomTarget && args.length >= 3) {
                    try {
                        volume = Float.parseFloat(args[2]);
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                soundString = args[isCustomTarget ? 1 : 0];
            } else {
                soundString = args[0];
            }
            if (args.length >= 3) {
                try {
                    if (args.length != 3 || !isCustomTarget) {
                        pitch = Float.parseFloat(args[isCustomTarget ? 3 : 2]);
                    }
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (args.length >= 4) {
                try {
                    if (args.length != 4 || !isCustomTarget) {
                        seed = Long.parseLong(args[isCustomTarget ? 4 : 3]);
                    }
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (isCustomTarget) {
                target = Bukkit.getPlayer((String)args[0]);
            }
            if (target == null) {
                sender.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                return;
            }
            if (!sender.hasPermission("opencreative.play-sound.bypass")) {
                Planet targetPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(target);
                Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                if (planet == null || !planet.equals(targetPlanet)) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
            }
            try {
                sound = Sound.valueOf((String)soundString.toUpperCase());
            }
            catch (IllegalArgumentException targetPlanet) {
                // empty catch block
            }
            volume = Math.clamp(volume, 1.0f, 100.0f);
            pitch = Math.clamp(pitch, 0.1f, 2.0f);
            Location location = target.getLocation().clone();
            if (volume < 100.0f) {
                location = location.add(0.0, -50.0, 0.0);
            }
            if (sound == null) {
                if (seed != null) {
                    target.playSound(location, soundString, SoundCategory.AMBIENT, volume, pitch, seed.longValue());
                } else {
                    target.playSound(location, soundString, volume, pitch);
                }
            } else if (seed != null) {
                target.playSound(location, sound, SoundCategory.AMBIENT, volume, pitch, seed.longValue());
            } else {
                target.playSound(location, sound, volume, pitch);
            }
            sender.sendMessage(MessageUtils.getLocaleMessage("commands.play-sound.played").replace("%sound%", soundString).replace("%volume%", String.valueOf(volume)).replace("%pitch%", String.valueOf(pitch)).replace("%player%", target.getName()));
        }
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            PlaySoundCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            PlaySoundCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            PlaySoundCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            PlaySoundCommand.$$$reportNull$$$0(6);
        }
        ArrayList<String> tabCompleter = new ArrayList<String>();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                tabCompleter.addAll(player.getWorld().getPlayers().stream().map(Player::getName).toList());
            } else if (args.length == 2) {
                tabCompleter.addAll(Registry.SOUNDS.stream().map(sound -> sound.getKey().asMinimalString()).toList());
            } else if (args.length == 3) {
                tabCompleter.add("100");
                tabCompleter.add("50");
                tabCompleter.add("20");
                tabCompleter.add("10");
            } else if (args.length == 4) {
                tabCompleter.add("1");
                tabCompleter.add("2");
                tabCompleter.add("0.1");
                tabCompleter.add("0.5");
            }
        }
        return tabCompleter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/minecraft/PlaySoundCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

