/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.minecraft;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class StopSoundCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            StopSoundCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            StopSoundCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            StopSoundCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            Bukkit.getServer().dispatchCommand(sender, "minecraft:stopsound " + String.join((CharSequence)" ", args));
        } else {
            String soundOrCategory;
            Player player = (Player)sender;
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            if (!player.hasPermission("opencreative.stop-sound.bypass")) {
                Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                if (planet == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                    return;
                }
                if (!planet.isOwner(player) && !planet.getWorldPlayers().canDevelop(player)) {
                    player.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
            }
            if (args.length == 0) {
                player.stopAllSounds();
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.stop-sound.stopped-all").replace("%player%", player.getName()));
                return;
            }
            Player target = player;
            if (args.length == 1) {
                soundOrCategory = args[0].toUpperCase();
            } else if (args.length == 2) {
                target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
                if (!sender.hasPermission("opencreative.stop-sound.bypass")) {
                    Planet planet;
                    Planet targetPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(target);
                    if (!(player.hasPermission("opencreative.stop-sound.bypass") || (planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) != null && planet.equals(targetPlanet))) {
                        player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                        return;
                    }
                }
                soundOrCategory = args[1].toUpperCase();
            } else {
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.stop-sound.help"));
                return;
            }
            Sound sound = null;
            SoundCategory category = null;
            try {
                sound = Sound.valueOf((String)soundOrCategory);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                category = SoundCategory.valueOf((String)soundOrCategory);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (sound != null) {
                target.stopSound(sound);
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.stop-sound.stopped-sound").replace("%sound%", soundOrCategory).replace("%player%", target.getName()));
            } else if (category != null) {
                target.stopSound(category);
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.stop-sound.stopped-category").replace("%category%", soundOrCategory).replace("%player%", target.getName()));
            } else {
                target.stopAllSounds();
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.stop-sound.stopped-all").replace("%player%", target.getName()));
            }
        }
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (sender == null) {
            StopSoundCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            StopSoundCommand.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            StopSoundCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            StopSoundCommand.$$$reportNull$$$0(6);
        }
        return Arrays.stream(SoundCategory.values()).map(c -> c.name().toLowerCase()).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/minecraft/StopSoundCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

