/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.JoinEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.LikeEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.PlayEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.QuitEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.GamePlayEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executors;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.other.Function;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.other.Method;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.coding.variables.WorldVariable;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldEnvironmentMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class EnvironmentCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            EnvironmentCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            EnvironmentCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            EnvironmentCommand.$$$reportNull$$$0(2);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            if (planet == null) {
                player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                return;
            }
            if (!planet.getWorldPlayers().canDevelop(player)) {
                player.sendMessage(MessageUtils.getLocaleMessage("not-developer"));
                return;
            }
            if (args.length == 0) {
                new WorldEnvironmentMenu(player, planet.getDevPlanet()).open(player);
            } else {
                block41 : switch (args[0].toLowerCase()) {
                    case "vars": 
                    case "variables": 
                    case "var": {
                        if (args.length == 1) {
                            return;
                        }
                        if (args[1].equalsIgnoreCase("size")) {
                            player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.size").replace("%count%", String.valueOf(planet.getVariables().getTotalVariablesAmount())));
                            break;
                        }
                        if (args[1].equalsIgnoreCase("set")) {
                            if (args.length <= 4) {
                                player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.set.help"));
                                return;
                            }
                            String varName = args[2];
                            VariableLink.VariableType type = VariableLink.VariableType.getEnum(args[3]);
                            if (type == null || type == VariableLink.VariableType.LOCAL) {
                                return;
                            }
                            ValueType valueType = ValueType.TEXT;
                            Object value = null;
                            switch (args[4].toLowerCase()) {
                                case "number": 
                                case "n": 
                                case "num": 
                                case "numb": {
                                    if (args.length == 5) {
                                        return;
                                    }
                                    String numberString = args[5];
                                    if (numberString.equalsIgnoreCase("p") || numberString.equalsIgnoreCase("pi")) {
                                        numberString = "3.1415926";
                                    }
                                    valueType = ValueType.NUMBER;
                                    try {
                                        value = MessageUtils.parseTicks(numberString);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                    break;
                                }
                                case "boolean": 
                                case "bool": 
                                case "b": {
                                    if (args.length == 5) {
                                        return;
                                    }
                                    value = Boolean.parseBoolean(args[5]);
                                    valueType = ValueType.BOOLEAN;
                                    break;
                                }
                                case "text": 
                                case "t": {
                                    value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 5, args.length));
                                    break;
                                }
                                case "item": 
                                case "i": {
                                    value = player.getInventory().getItemInMainHand();
                                    valueType = ValueType.ITEM;
                                    break;
                                }
                                case "location": 
                                case "loc": {
                                    try {
                                        if (args.length < 8) {
                                            return;
                                        }
                                        double x = this.parseCoordinate(args[5], player.getX());
                                        double y = this.parseCoordinate(args[6], player.getY());
                                        double z = this.parseCoordinate(args[7], player.getZ());
                                        float yaw = player.getYaw();
                                        float pitch = player.getPitch();
                                        if (args.length >= 9) {
                                            yaw = this.parseCoordinate(args[8], player.getYaw());
                                        }
                                        if (args.length >= 10) {
                                            pitch = this.parseCoordinate(args[9], player.getPitch());
                                        }
                                        value = new Location(planet.getTerritory().getWorld(), x, y, z, yaw, pitch);
                                        valueType = ValueType.LOCATION;
                                    }
                                    catch (NumberFormatException x) {}
                                    break;
                                }
                                case "vector": 
                                case "vec": {
                                    try {
                                        if (args.length < 6) {
                                            return;
                                        }
                                        double x = Double.parseDouble(args[5]);
                                        double y = Double.parseDouble(args[6]);
                                        double z = Double.parseDouble(args[7]);
                                        value = new Vector(x, y, z);
                                        valueType = ValueType.VECTOR;
                                        break;
                                    }
                                    catch (NumberFormatException x) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (value == null) break;
                            if (planet.getVariables().setVariableValue(new VariableLink(varName, type), valueType, value)) {
                                player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.set.message").replace("%variable%", varName).replace("%value%", (CharSequence)(value.toString().length() > 100 ? value.toString().substring(0, 100) + "..." : value.toString())));
                                break;
                            }
                            player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.set.limit").replace("%limit%", String.valueOf(planet.getLimits().getVariablesAmountLimit())));
                            break;
                        }
                        if (args[1].equalsIgnoreCase("get")) {
                            String message;
                            WorldVariable var;
                            VariableLink.VariableType type = VariableLink.VariableType.GLOBAL;
                            if (args.length == 2) {
                                return;
                            }
                            String varName = args[2];
                            if (args.length >= 4 && ((type = VariableLink.VariableType.getEnum(args[3])) == null || type == VariableLink.VariableType.LOCAL)) {
                                type = VariableLink.VariableType.GLOBAL;
                            }
                            if ((var = planet.getVariables().getVariable(varName, type, null)) == null) {
                                player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.get.empty"));
                                break;
                            }
                            message = message.replace("%value%", (CharSequence)((message = MessageUtils.getLocaleMessage("environment.variables.get.message").replace("%variable%", varName).replace("%type%", var.getType().getLocaleName()).replace("%valuetype%", var.getVarType().getLocalized())).length() + var.getValue().toString().length() > 700 ? var.getValue().toString().substring(0, Math.min(var.getValue().toString().length(), 700)) + "..." : var.getValue().toString()));
                            player.sendMessage(message);
                            break;
                        }
                        if (args[1].equalsIgnoreCase("clear")) {
                            planet.getVariables().clearVariables();
                            player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.cleared"));
                            break;
                        }
                        if (!args[1].equalsIgnoreCase("list")) break;
                        int page = 0;
                        ArrayList<WorldVariable> allVariables = new ArrayList<WorldVariable>(planet.getVariables().getSet());
                        if (allVariables.isEmpty()) {
                            player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.list.empty"));
                            return;
                        }
                        if (args.length > 2) {
                            try {
                                page = Integer.parseInt(args[2]) - 1;
                                if (page < 0 || page * 20 > allVariables.size()) {
                                    page = 0;
                                }
                            }
                            catch (NumberFormatException var) {
                                // empty catch block
                            }
                        }
                        int current = Math.min((page + 1) * 20, allVariables.size());
                        ArrayList variables = new ArrayList(allVariables.subList(page * 20, current));
                        Sounds.DEV_VAR_LIST.play((Audience)player);
                        player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.list.header").replace("%current%", String.valueOf(current)).replace("%amount%", String.valueOf(allVariables.size())));
                        for (WorldVariable variable : variables) {
                            Object value;
                            Object name = variable.getName();
                            VariableLink.VariableType type = variable.getVarType();
                            Object object = value = variable.getValue() != null ? variable.getValue().toString() : "null";
                            if (((String)name).length() > 40) {
                                name = ((String)name).substring(0, 40) + "...";
                            }
                            if (((String)value).length() > 40) {
                                value = ((String)value).substring(0, 40) + "...";
                            }
                            player.sendMessage(MessageUtils.getLocaleMessage("environment.variables.list.variable", false).replace("%name%", (CharSequence)name).replace("%type%", type.getLocalized()).replace("%value%", (CharSequence)value));
                        }
                        Component navigation = MessageUtils.toComponent(MessageUtils.getLocaleMessage("environment.variables.list.navigation"));
                        if (++page * 20 > 20) {
                            navigation = navigation.append(MessageUtils.toComponent(MessageUtils.getLocaleMessage("environment.variables.list.previous-page")).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/environment variables list " + (page - 1)))));
                        }
                        if (allVariables.size() > current) {
                            navigation = navigation.append(MessageUtils.toComponent(MessageUtils.getLocaleMessage("environment.variables.list.next-page")).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/environment variables list " + (page + 1)))));
                        }
                        if (!MessageUtils.toComponent(MessageUtils.getLocaleMessage("environment.variables.list.navigation")).equals((Object)navigation)) {
                            player.sendMessage(navigation);
                        }
                        player.sendMessage(" ");
                        break;
                    }
                    case "containers": 
                    case "barrel": 
                    case "barrels": {
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            player.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        devPlanet.setContainerMaterial(devPlanet.getContainerMaterial() == Material.CHEST ? Material.BARREL : Material.CHEST);
                        devPlanet.updateContainers();
                        break;
                    }
                    case "container": {
                        if (args.length < 2) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        Material material = Material.CHEST;
                        try {
                            material = Material.valueOf((String)(args[1].equalsIgnoreCase("chest") || args[1].equalsIgnoreCase("barrel") || args[1].equalsIgnoreCase("shulker_box") ? args[1].toUpperCase() : args[1].toUpperCase() + "_SHULKER_BOX"));
                        }
                        catch (Exception current) {
                            // empty catch block
                        }
                        if (!devPlanet.setContainerMaterial(material)) break;
                        devPlanet.updateContainers();
                        break;
                    }
                    case "drops": 
                    case "drop": 
                    case "drop-items": {
                        boolean value;
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            player.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        boolean bl = value = !devPlanet.isDropItems();
                        if (args.length >= 2) {
                            value = switch (args[1].toLowerCase()) {
                                case "on", "enable" -> true;
                                default -> false;
                            };
                        }
                        player.sendMessage(MessageUtils.getLocaleMessage("environment.drops." + (value ? "enabled" : "disabled")));
                        devPlanet.setDropItems(value);
                        Sounds.DEV_SETTINGS_DROP_ITEMS.play((Audience)player);
                        break;
                    }
                    case "night-vision": {
                        boolean value;
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            player.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        boolean bl = value = !devPlanet.isNightVision();
                        if (args.length >= 2) {
                            value = switch (args[1].toLowerCase()) {
                                case "on", "enable" -> true;
                                default -> false;
                            };
                        }
                        devPlanet.setNightVision(value);
                        if (value) {
                            player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0, false, false, false));
                        } else {
                            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                        }
                        player.sendMessage(MessageUtils.getLocaleMessage("environment.night-vision." + (value ? "enabled" : "disabled")));
                        Sounds.DEV_SETTINGS_NIGHT_VISION.play((Audience)player);
                        break;
                    }
                    case "save-location": {
                        boolean value;
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            player.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        boolean bl = value = !devPlanet.isSaveLocation();
                        if (args.length >= 2) {
                            value = switch (args[1].toLowerCase()) {
                                case "on", "enable" -> true;
                                default -> false;
                            };
                        }
                        player.sendMessage(MessageUtils.getLocaleMessage("environment.save-location." + (value ? "enabled" : "disabled")));
                        devPlanet.setSaveLocation(value);
                        Sounds.DEV_SETTINGS_SAVE_LOCATION.play((Audience)player);
                        break;
                    }
                    case "createplatform": {
                        if (!sender.hasPermission("opencreative.debug")) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                            return;
                        }
                        if (args.length < 3) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        int x = 1;
                        int z = 1;
                        try {
                            x = Integer.parseInt(args[1]);
                        }
                        catch (Exception variables) {
                            // empty catch block
                        }
                        try {
                            z = Integer.parseInt(args[2]);
                        }
                        catch (Exception variables) {
                            // empty catch block
                        }
                        if (!devPlanet.createPlatform(x, z)) break;
                        sender.sendMessage("Created platform " + x + " " + z);
                        break;
                    }
                    case "platform": 
                    case "p": {
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        if (devPlanet.getPlatforms().size() >= devPlanet.getPlanet().getLimits().getCodingPlatformsLimit()) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("environment.platform.limit").replace("%amount%", String.valueOf(devPlanet.getPlanet().getLimits().getCodingPlatformsLimit())));
                            return;
                        }
                        DevPlatform platform = devPlanet.getDevPlatformer().getNextAvailablePlatform(devPlanet);
                        devPlanet.claimPlatform(platform, player);
                        break;
                    }
                    case "sign": {
                        if (args.length < 2) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        Material material = Material.OAK_WALL_SIGN;
                        try {
                            material = Material.valueOf((String)(args[1].toUpperCase() + "_WALL_SIGN"));
                        }
                        catch (Exception z) {
                            // empty catch block
                        }
                        if (!devPlanet.setSignMaterial(material)) break;
                        Sounds.DEV_PLATFORM_SIGN.play((Audience)player);
                        devPlanet.updateSigns();
                        break;
                    }
                    case "floor": {
                        if (args.length < 2) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        Material material = Material.WHITE_STAINED_GLASS;
                        try {
                            material = Material.valueOf((String)(args[1].equalsIgnoreCase("barrier") || args[1].equalsIgnoreCase("glass") ? args[1].toUpperCase() : args[1].toUpperCase() + "_STAINED_GLASS"));
                        }
                        catch (Exception z) {
                            // empty catch block
                        }
                        DevPlatform currentPlatform = devPlanet.getPlatformInLocation(player.getLocation());
                        boolean changed = false;
                        if (currentPlatform == null) {
                            for (DevPlatform platform : devPlanet.getPlatforms()) {
                                if (!platform.setFloorMaterial(material)) continue;
                                changed = true;
                            }
                        } else {
                            changed = currentPlatform.setFloorMaterial(material);
                        }
                        if (!changed) break;
                        Sounds.DEV_PLATFORM_COLOR.play((Audience)player);
                        break;
                    }
                    case "action": {
                        if (args.length < 2) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        Material material = Material.GRAY_STAINED_GLASS;
                        try {
                            material = Material.valueOf((String)(args[1].equalsIgnoreCase("barrier") || args[1].equalsIgnoreCase("glass") ? args[1].toUpperCase() : args[1].toUpperCase() + "_STAINED_GLASS"));
                        }
                        catch (Exception currentPlatform) {
                            // empty catch block
                        }
                        DevPlatform currentPlatform = devPlanet.getPlatformInLocation(player.getLocation());
                        boolean changed = false;
                        if (currentPlatform == null) {
                            for (DevPlatform platform : devPlanet.getPlatforms()) {
                                if (!platform.setActionMaterial(material)) continue;
                                changed = true;
                            }
                        } else {
                            changed = currentPlatform.setActionMaterial(material);
                        }
                        if (!changed) break;
                        Sounds.DEV_PLATFORM_COLOR.play((Audience)player);
                        break;
                    }
                    case "event": 
                    case "executor": {
                        if (args.length < 2) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        Material material = Material.BLUE_STAINED_GLASS;
                        try {
                            material = Material.valueOf((String)(args[1].equalsIgnoreCase("barrier") || args[1].equalsIgnoreCase("glass") ? args[1].toUpperCase() : args[1].toUpperCase() + "_STAINED_GLASS"));
                        }
                        catch (Exception currentPlatform) {
                            // empty catch block
                        }
                        DevPlatform currentPlatform = devPlanet.getPlatformInLocation(player.getLocation());
                        boolean changed = false;
                        if (currentPlatform == null) {
                            for (DevPlatform platform : devPlanet.getPlatforms()) {
                                if (!platform.setEventMaterial(material)) continue;
                                changed = true;
                            }
                        } else {
                            changed = currentPlatform.setEventMaterial(material);
                        }
                        if (!changed) break;
                        Sounds.DEV_PLATFORM_COLOR.play((Audience)player);
                        break;
                    }
                    case "theme": 
                    case "settheme": 
                    case "themes": {
                        if (args.length < 2) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                        if (devPlanet == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                            return;
                        }
                        DevPlatform platform = devPlanet.getPlatformInLocation(player.getLocation());
                        if (platform == null) {
                            return;
                        }
                        switch (args[1].toLowerCase()) {
                            case "dark": 
                            case "black": 
                            case "darkmode": 
                            case "space": 
                            case "night": {
                                if (!platform.setMaterials(Material.BARRIER, Material.GRAY_STAINED_GLASS, Material.BLACK_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "light": 
                            case "white": 
                            case "lightmode": {
                                if (!platform.setMaterials(Material.BARRIER, Material.GRAY_STAINED_GLASS, Material.WHITE_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "pink": 
                            case "magenta": 
                            case "purple": {
                                if (!platform.setMaterials(Material.BARRIER, Material.PINK_STAINED_GLASS, Material.MAGENTA_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "blue": 
                            case "ocean": 
                            case "cyan": {
                                if (!platform.setMaterials(Material.BARRIER, Material.BLUE_STAINED_GLASS, Material.LIGHT_BLUE_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "ukraine": 
                            case "ua": 
                            case "uk": {
                                if (!platform.setMaterials(Material.BARRIER, Material.BLUE_STAINED_GLASS, Material.YELLOW_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "rhombus": 
                            case "old": 
                            case "legacy": {
                                if (!platform.setMaterials(Material.WHITE_STAINED_GLASS, Material.LIGHT_BLUE_STAINED_GLASS, Material.LIGHT_GRAY_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "just": 
                            case "planet": 
                            case "default": {
                                if (!platform.setMaterials(Material.WHITE_STAINED_GLASS, Material.BLUE_STAINED_GLASS, Material.GRAY_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "art": 
                            case "artur": {
                                if (!platform.setMaterials(Material.WHITE_STAINED_GLASS, Material.BLACK_STAINED_GLASS, Material.CYAN_STAINED_GLASS)) break block41;
                                break;
                            }
                            case "cloud": {
                                if (!platform.setMaterials(Material.WHITE_STAINED_GLASS, Material.CYAN_STAINED_GLASS, Material.GRAY_STAINED_GLASS)) break block41;
                                break;
                            }
                            default: {
                                break block41;
                            }
                        }
                        Sounds.DEV_PLATFORM_COLOR.play((Audience)player);
                        break;
                    }
                    case "execute": 
                    case "exec": 
                    case "launch": 
                    case "run": {
                        if (planet.getMode() != Planet.Mode.PLAYING) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("world.not-in-play-mode"));
                            return;
                        }
                        if (args.length < 3) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                        String eventName = args[1];
                        String argument = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                        switch (eventName.toLowerCase()) {
                            case "join": 
                            case "player_join": {
                                Player eventPlayer = Bukkit.getPlayer((String)argument);
                                if (eventPlayer == null || !planet.getTerritory().getWorld().getPlayers().contains(eventPlayer)) {
                                    sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.offline"));
                                    return;
                                }
                                new JoinEvent(player).callEvent();
                                break;
                            }
                            case "quit": 
                            case "player_quit": {
                                Player eventPlayer = Bukkit.getPlayer((String)argument);
                                if (eventPlayer == null || !planet.getTerritory().getWorld().getPlayers().contains(eventPlayer)) {
                                    sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.offline"));
                                    return;
                                }
                                new QuitEvent(player).callEvent();
                                break;
                            }
                            case "liked": 
                            case "like": 
                            case "player_like": 
                            case "player_liked": {
                                Player eventPlayer = Bukkit.getPlayer((String)argument);
                                if (eventPlayer == null || !planet.getTerritory().getWorld().getPlayers().contains(eventPlayer)) {
                                    sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.offline"));
                                    return;
                                }
                                new LikeEvent(player).callEvent();
                                break;
                            }
                            case "play": 
                            case "player_play": {
                                Player eventPlayer = Bukkit.getPlayer((String)argument);
                                if (eventPlayer == null || !planet.getTerritory().getWorld().getPlayers().contains(eventPlayer)) {
                                    sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.offline"));
                                    return;
                                }
                                new PlayEvent(player).callEvent();
                                break;
                            }
                            case "world_play": {
                                new GamePlayEvent(planet).callEvent();
                                break;
                            }
                            case "function": 
                            case "func": {
                                boolean found = false;
                                for (Function function : planet.getTerritory().getScript().getExecutors().getFunctionsList()) {
                                    if (!argument.equalsIgnoreCase(function.getName())) continue;
                                    if (!found) {
                                        found = true;
                                        sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.function").replace("%function%", argument));
                                    }
                                    Executors.activate(function, new JoinEvent(player));
                                }
                                if (found) break block41;
                                sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.function-not-found"));
                                break;
                            }
                            case "method": 
                            case "meth": {
                                boolean found = false;
                                for (Method method : planet.getTerritory().getScript().getExecutors().getMethodsList()) {
                                    if (!argument.equalsIgnoreCase(method.getName())) continue;
                                    if (!found) {
                                        found = true;
                                        sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.method").replace("%method%", argument));
                                    }
                                    Executors.activate(method, new JoinEvent(player));
                                }
                                if (found) break block41;
                                sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.method-not-found"));
                                break;
                            }
                            default: {
                                sender.sendMessage(MessageUtils.getLocaleMessage("environment.execute.help"));
                                break;
                            }
                        }
                        break;
                    }
                    case "debug": {
                        if (args.length == 1) {
                            player.sendMessage(MessageUtils.getLocaleMessage("environment.debug.help"));
                            return;
                        }
                        if (args[1].equalsIgnoreCase("enable") || args[1].equalsIgnoreCase("on")) {
                            for (Player planetPlayer : planet.getPlayers()) {
                                planetPlayer.sendMessage(MessageUtils.getPlayerLocaleMessage("environment.debug.enabled", (OfflinePlayer)player));
                            }
                            Sounds.DEV_DEBUG_ON.play((Audience)player);
                            planet.setDebug(true);
                            break;
                        }
                        if (!args[1].equalsIgnoreCase("disable") && !args[1].equalsIgnoreCase("off")) break;
                        for (Player planetPlayer : planet.getPlayers()) {
                            planetPlayer.sendMessage(MessageUtils.getPlayerLocaleMessage("environment.debug.disabled", (OfflinePlayer)player));
                        }
                        Sounds.DEV_DEBUG_OFF.play((Audience)player);
                        planet.setDebug(false);
                    }
                }
            }
        }
    }

    @Override
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        Planet planet;
        Object player;
        if (sender == null) {
            EnvironmentCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            EnvironmentCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            EnvironmentCommand.$$$reportNull$$$0(5);
        }
        ArrayList<String> tabCompleter = new ArrayList<String>();
        if (args.length == 1) {
            Collections.addAll(tabCompleter, "platform", "variables", "debug", "execute", "barrel", "floor", "action", "theme", "event", "sign", "save-location", "night-vision", "drops");
            return tabCompleter;
        }
        if (args.length == 2) {
            if (List.of("var", "vars", "variables").contains(args[0].toLowerCase())) {
                Collections.addAll(tabCompleter, "set", "get", "size", "clear", "list");
            } else if (List.of("execute", "exec", "run").contains(args[0].toLowerCase())) {
                Collections.addAll(tabCompleter, "function", "method", "player_join", "player_quit", "player_liked", "player_play", "world_play");
            } else if ("debug".equalsIgnoreCase(args[0]) || "drops".equalsIgnoreCase(args[0]) || "night-vision".equalsIgnoreCase(args[0]) || "save-location".equalsIgnoreCase(args[0])) {
                Collections.addAll(tabCompleter, "on", "off");
            } else if ("floor".equalsIgnoreCase(args[0]) || "event".equalsIgnoreCase(args[0]) || "action".equalsIgnoreCase(args[0])) {
                Collections.addAll(tabCompleter, "barrier", "black", "blue", "light_blue", "light_gray", "white", "red", "orange", "yellow", "purple", "green", "lime", "magenta", "brown", "cyan", "pink");
            } else if ("theme".equalsIgnoreCase(args[0])) {
                Collections.addAll(tabCompleter, "default", "dark", "light", "legacy", "cloud", "art", "ukraine", "blue", "purple");
            } else if ("sign".equalsIgnoreCase(args[0])) {
                Collections.addAll(tabCompleter, "oak", "acacia", "bamboo", "cherry", "birch", "jungle");
            } else if ("container".equalsIgnoreCase(args[0])) {
                Collections.addAll(tabCompleter, "barrel", "chest", "black", "blue", "light_blue", "light_gray", "white", "red", "orange", "yellow", "purple", "green", "lime", "magenta", "brown", "cyan", "pink");
            }
            return tabCompleter;
        }
        if (List.of("execute", "exec", "run").contains(args[0].toLowerCase()) && sender instanceof Player) {
            player = (Player)sender;
            if (PlayerUtils.isEntityInLobby((Entity)player)) {
                return tabCompleter;
            }
            planet = OpenCreative.getPlanetsManager().getPlanetByPlayer((Player)player);
            if (planet == null || !planet.getWorldPlayers().canDevelop((Player)player)) {
                return tabCompleter;
            }
            if (List.of("join", "quit", "player_join", "player_quit", "player_play", "play", "player_liked", "liked").contains(args[1].toLowerCase())) {
                tabCompleter.addAll(planet.getTerritory().getWorld().getPlayers().stream().map(Player::getName).toList());
            } else if (args[1].equalsIgnoreCase("function")) {
                tabCompleter.addAll(planet.getTerritory().getScript().getExecutors().getFunctionsList().stream().map(Function::getName).toList());
            } else if (args[1].equalsIgnoreCase("method")) {
                tabCompleter.addAll(planet.getTerritory().getScript().getExecutors().getMethodsList().stream().map(Method::getName).toList());
            }
        }
        if (List.of("var", "vars", "variables").contains(args[0].toLowerCase())) {
            List vars;
            ArrayList<WorldVariable> allVariables;
            if (args[1].equalsIgnoreCase("set")) {
                if (args.length == 3 && sender instanceof Player) {
                    player = (Player)sender;
                    if (PlayerUtils.isEntityInLobby((Entity)player)) {
                        return tabCompleter;
                    }
                    planet = OpenCreative.getPlanetsManager().getPlanetByPlayer((Player)player);
                    if (planet == null || !planet.getWorldPlayers().canDevelop((Player)player)) {
                        return tabCompleter;
                    }
                    allVariables = new ArrayList<WorldVariable>(planet.getVariables().getSet());
                    if (allVariables.isEmpty()) {
                        return tabCompleter;
                    }
                    vars = allVariables.subList(Math.max(0, allVariables.size() - 10), allVariables.size());
                    tabCompleter.addAll(vars.stream().map(WorldVariable::getName).toList());
                }
                if (args.length == 4) {
                    Collections.addAll(tabCompleter, "global", "saved");
                }
                if (args.length == 5) {
                    Collections.addAll(tabCompleter, "text", "number", "location", "item", "boolean", "vector");
                }
                if (args.length == 6) {
                    switch (args[4].toLowerCase()) {
                        case "number": 
                        case "n": 
                        case "numb": 
                        case "num": {
                            Collections.addAll(tabCompleter, "0", "1", "16", "32", "64", "100", "500");
                            break;
                        }
                        case "boolean": 
                        case "b": 
                        case "bool": {
                            Collections.addAll(tabCompleter, "true", "false");
                        }
                    }
                }
            }
            if (args[1].equalsIgnoreCase("get")) {
                if (args.length == 3) {
                    if (sender instanceof Player) {
                        player = (Player)sender;
                        if (PlayerUtils.isEntityInLobby((Entity)player)) {
                            return tabCompleter;
                        }
                        Planet planet2 = OpenCreative.getPlanetsManager().getPlanetByPlayer((Player)player);
                        if (planet2 == null || !planet2.getWorldPlayers().canDevelop((Player)player)) {
                            return tabCompleter;
                        }
                        allVariables = new ArrayList<WorldVariable>(planet2.getVariables().getSet());
                        if (allVariables.isEmpty()) {
                            return tabCompleter;
                        }
                        vars = allVariables.subList(Math.max(0, allVariables.size() - 10), allVariables.size());
                        tabCompleter.addAll(vars.stream().map(WorldVariable::getName).toList());
                    }
                } else if (args.length == 4) {
                    Collections.addAll(tabCompleter, "global", "saved");
                } else {
                    return null;
                }
            }
        }
        return tabCompleter;
    }

    private double parseCoordinate(String arg, double current) throws NumberFormatException {
        if (arg.startsWith("~")) {
            return arg.equals("~") ? current : current + Double.parseDouble(arg.substring(1));
        }
        return Double.parseDouble(arg);
    }

    private float parseCoordinate(String arg, float current) throws NumberFormatException {
        if (arg.startsWith("~")) {
            return arg.equals("~") ? current : current + Float.parseFloat(arg.substring(1));
        }
        return Float.parseFloat(arg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/EnvironmentCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

