/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class JoinCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        Player player;
        if (sender == null) {
            JoinCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            JoinCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            JoinCommand.$$$reportNull$$$0(2);
        }
        if (sender instanceof Player && !CooldownUtils.checkAndSetCooldownWithMessage(player = (Player)sender, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
            return;
        }
        if (OpenCreative.getSettings().isMaintenance() && !sender.hasPermission("opencreative.maintenance.bypass")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("maintenance"));
            return;
        }
        if (OpenCreative.getStability().isVeryBad() && !sender.hasPermission("opencreative.stability.bypass")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
            return;
        }
        if (args.length == 2) {
            if (!sender.hasPermission("opencreative.join.others")) {
                sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                return;
            }
            Player player2 = Bukkit.getPlayer((String)args[1]);
            if (player2 == null) {
                sender.sendMessage(MessageUtils.getLocaleMessage("not-found-player"));
                return;
            }
            sender.sendMessage(MessageUtils.getPlayerLocaleMessage("commands.join.connecting", (OfflinePlayer)player2).replace("%id%", args[0]));
            if (!JoinCommand.handlePlayerConnection(player2, args[0])) {
                sender.sendMessage(MessageUtils.getPlayerLocaleMessage("commands.join.failed", (OfflinePlayer)player2));
            }
        } else if (args.length != 1) {
            sender.sendMessage(MessageUtils.getLocaleMessage("commands.join.help"));
        } else if (sender instanceof Player) {
            player = (Player)sender;
            JoinCommand.handlePlayerConnection(player, args[0]);
        } else {
            sender.sendMessage(MessageUtils.getLocaleMessage("only-players"));
        }
    }

    public static boolean handlePlayerConnection(Player player, String planetId) {
        Planet foundPlanet = JoinCommand.findPlanet(planetId);
        if (foundPlanet == null) {
            Sounds.PLAYER_FAIL.play((Audience)player);
            player.clearTitle();
            player.sendMessage(MessageUtils.getPlayerLocaleMessage("no-planet-found", (OfflinePlayer)player));
            return false;
        }
        if (foundPlanet.equals(OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
            player.sendMessage(MessageUtils.getPlayerLocaleMessage("same-world", (OfflinePlayer)player));
            return false;
        }
        foundPlanet.connectPlayer(player);
        return true;
    }

    public static Planet findPlanet(String planetId) {
        Set<Planet> planets = OpenCreative.getPlanetsManager().getPlanets();
        if (planets.isEmpty()) {
            return null;
        }
        return planets.stream().filter(planet -> String.valueOf(planet.getId()).equals(planetId) || planet.getInformation().getCustomID().equalsIgnoreCase(planetId)).findFirst().orElse(null);
    }

    @Override
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (sender == null) {
            JoinCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            JoinCommand.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            JoinCommand.$$$reportNull$$$0(5);
        }
        return switch (args.length) {
            case 1 -> OpenCreative.getPlanetsManager().getPlanets().stream().map(planet -> planet.getInformation().getCustomID()).toList();
            case 2 -> {
                if (sender.hasPermission("opencreative.join.others")) {
                    yield Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
                }
                yield Collections.emptyList();
            }
            default -> Collections.emptyList();
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/JoinCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

