/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.events.planet.PlanetSharingChangeEvent;
import ua.mcchickenstudio.opencreative.menus.world.settings.EntitiesBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformers;

public class WorldCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String arg;
        if (sender == null) {
            WorldCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            WorldCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            WorldCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.getLocaleMessage("only-players"));
            return;
        }
        Player player = (Player)sender;
        if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
            return;
        }
        switch (arg = args.length == 0 ? "" : args[0].toLowerCase()) {
            case "deletemobs": 
            case "mobs": 
            case "entities": {
                if (planet.getWorldPlayers().canBuild(player)) {
                    new EntitiesBrowserMenu(player, planet).open(player);
                    break;
                }
                sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                break;
            }
            case "setspawn": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.getWorld().setSpawnLocation(player.getLocation());
                player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-spawn.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-spawn.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(130L))));
                Sounds.WORLD_SETTINGS_SPAWN_SET.play((Audience)player);
                break;
            }
            case "spawn": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.teleport(player.getWorld().getSpawnLocation());
                Sounds.WORLD_SETTINGS_SPAWN_TELEPORT.play((Audience)player);
                break;
            }
            case "close": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (planet.getSharing() != Planet.Sharing.PUBLIC) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(planet, planet.getSharing(), Planet.Sharing.PRIVATE);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                Sounds.WORLD_SETTINGS_SHARING_PRIVATE.play((Audience)player);
                planet.setSharing(Planet.Sharing.PRIVATE);
                player.sendMessage(MessageUtils.getLocaleMessage("settings.world-sharing.disabled"));
                break;
            }
            case "open": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (planet.getSharing() == Planet.Sharing.PUBLIC) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(planet, planet.getSharing(), Planet.Sharing.PUBLIC);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                Sounds.WORLD_SETTINGS_SHARING_PUBLIC.play((Audience)player);
                planet.setSharing(Planet.Sharing.PUBLIC);
                player.sendMessage(MessageUtils.getLocaleMessage("settings.world-sharing.enabled"));
                break;
            }
            case "whitelist": 
            case "white": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (planet.isOwner(args[1])) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("same-player"));
                    return;
                }
                int limit = planet.getLimits().getWhitelistedLimit();
                if (planet.getWorldPlayers().getWhitelistedPlayers().size() > limit) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.white-list.limit").replace("%limit%", String.valueOf(limit)));
                    return;
                }
                Player playerToWhitelist = Bukkit.getPlayer((String)args[1]);
                if (playerToWhitelist == null || !planet.getPlayers().contains(playerToWhitelist)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("menus.world-settings-players.not-in-world"));
                    return;
                }
                sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.players.white-list.added", (OfflinePlayer)playerToWhitelist));
                planet.getWorldPlayers().banPlayer(args[1]);
                break;
            }
            case "ban": 
            case "block": 
            case "blacklist": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (planet.isOwner(args[1])) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("same-player"));
                    return;
                }
                int limit = planet.getLimits().getBlacklistedLimit();
                if (planet.getWorldPlayers().getBannedPlayers().size() > limit) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.black-list.limit").replace("%limit%", String.valueOf(limit)));
                    return;
                }
                Player playerToBan = Bukkit.getPlayer((String)args[1]);
                if (playerToBan == null || !planet.getPlayers().contains(playerToBan)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("menus.world-settings-players.not-in-world"));
                    return;
                }
                if (playerToBan.hasPermission("opencreative.world.ban.bypass")) {
                    sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.players.black-list.cannot", (OfflinePlayer)playerToBan));
                    return;
                }
                sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.players.black-list.added", (OfflinePlayer)playerToBan));
                planet.getWorldPlayers().banPlayer(args[1]);
                break;
            }
            case "kick": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                ArrayList<Object> playersToKick = new ArrayList<Object>();
                if (List.of("*", "@a").contains(args[1].toLowerCase())) {
                    playersToKick.addAll(planet.getPlayers());
                    playersToKick.remove(player);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.kick.all"));
                } else {
                    if (planet.isOwner(args[1])) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("same-player"));
                        return;
                    }
                    Player playerToKick = Bukkit.getPlayer((String)args[1]);
                    if (playerToKick == null || !planet.getPlayers().contains(playerToKick)) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("menus.world-settings-players.not-in-world"));
                        return;
                    }
                    if (playerToKick.hasPermission("opencreative.world.kick.bypass")) {
                        sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.players.kick.cannot", (OfflinePlayer)playerToKick));
                        return;
                    }
                    playersToKick.add(playerToKick);
                }
                for (Player player2 : playersToKick) {
                    planet.getWorldPlayers().kickPlayer(player2);
                }
                break;
            }
            case "unban": 
            case "unblacklist": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (planet.isOwner(args[1])) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("same-player"));
                    return;
                }
                if (!planet.getWorldPlayers().isBanned(args[1])) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("menus.world-settings-players.not-in-world"));
                    return;
                }
                planet.getWorldPlayers().unbanPlayer(args[1]);
                sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.players.black-list.removed", Bukkit.getOfflinePlayer((String)args[1])));
                break;
            }
            case "unwhitelist": 
            case "unwhite": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                if (planet.isOwner(args[1])) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("same-player"));
                    return;
                }
                if (!planet.getWorldPlayers().isWhitelisted(args[1])) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("menus.world-settings-players.not-in-world"));
                    return;
                }
                planet.getWorldPlayers().removeFromWhitelist(args[1]);
                sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.players.white-list.removed", Bukkit.getOfflinePlayer((String)args[1])));
                break;
            }
            case "exp": 
            case "e": 
            case "experiment": 
            case "experiments": {
                if (!planet.isOwner(player)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (!sender.hasPermission("opencreative.world.experiments")) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                    return;
                }
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                planet.getExperiments().handle(player, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "size": {
                if (!sender.hasPermission("opencreative.world.size")) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                    return;
                }
                long settingsSize = ua.mcchickenstudio.opencreative.utils.FileUtils.getFileSize(new File(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetFolder(planet), "settings.yml"));
                long l = ua.mcchickenstudio.opencreative.utils.FileUtils.getFileSize(new File(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetFolder(planet), "codeScript.yml"));
                long variablesSize = ua.mcchickenstudio.opencreative.utils.FileUtils.getFileSize(new File(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetFolder(planet), "variables.json"));
                long dataSize = ua.mcchickenstudio.opencreative.utils.FileUtils.getFolderSize(new File(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetFolder(planet), "playersData"));
                long folderSize = ua.mcchickenstudio.opencreative.utils.FileUtils.getFolderSize(ua.mcchickenstudio.opencreative.utils.FileUtils.getPlanetFolder(planet));
                long devWorldSize = ua.mcchickenstudio.opencreative.utils.FileUtils.getFolderSize(ua.mcchickenstudio.opencreative.utils.FileUtils.getDevPlanetFolder(planet.getDevPlanet()));
                long worldSize = folderSize - dataSize - variablesSize - l - settingsSize;
                sender.sendMessage(MessageUtils.getLocaleMessage("world.size").replace("%total%", FileUtils.byteCountToDisplaySize(folderSize + devWorldSize)).replace("%world%", FileUtils.byteCountToDisplaySize(worldSize)).replace("%script%", FileUtils.byteCountToDisplaySize(l)).replace("%variables%", FileUtils.byteCountToDisplaySize(variablesSize)).replace("%dev%", FileUtils.byteCountToDisplaySize(devWorldSize)).replace("%data%", FileUtils.byteCountToDisplaySize(dataSize)).replace("%settings%", FileUtils.byteCountToDisplaySize(settingsSize)));
                break;
            }
            case "mem": 
            case "tps": 
            case "memory": {
                if (!sender.hasPermission("opencreative.world.memory")) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                    return;
                }
                int chunks = planet.getTerritory().getWorld().getChunkCount() + (planet.getDevPlanet().isLoaded() ? planet.getDevPlanet().getWorld().getChunkCount() : 0);
                int entities = planet.getTerritory().getWorld().getEntityCount() + (planet.getDevPlanet().isLoaded() ? planet.getDevPlanet().getWorld().getEntityCount() : 0);
                sender.sendMessage("");
                sender.sendMessage(" Chunks: " + chunks);
                sender.sendMessage(" Entities: " + entities);
                sender.sendMessage("");
                break;
            }
            case "platformer": {
                if (!sender.hasPermission("opencreative.world.set-platformer")) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                    return;
                }
                if (args.length == 1) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                String platformerID = args[1].toLowerCase();
                DevPlatformer platformer = DevPlatformers.getInstance().getById(platformerID);
                if (platformerID.equals("reset") || platformerID.equals("default")) {
                    platformer = OpenCreative.getDevPlatformer();
                    planet.getDevPlanet().setPlatformerID(platformer.getID());
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.platformer.reset").replace("%id%", platformer.getID()));
                    if (planet.getDevPlanet().isLoaded()) {
                        platformer.setWorldBorder(planet.getDevPlanet());
                        planet.getDevPlanet().displayWorldBorders();
                    }
                    return;
                }
                if (platformer == null) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.platformer.not-found").replace("%id%", platformerID));
                    return;
                }
                planet.getDevPlanet().setPlatformerID(platformer.getID());
                sender.sendMessage(MessageUtils.getLocaleMessage("world.platformer.set").replace("%id%", platformer.getID()));
                if (!planet.getDevPlanet().isLoaded()) break;
                platformer.setWorldBorder(planet.getDevPlanet());
                planet.getDevPlanet().displayWorldBorders();
                break;
            }
            case "info": {
                this.sendPlanetInfo((CommandSender)player, planet);
                break;
            }
            default: {
                if (planet.isOwner(player)) {
                    new WorldSettingsMenu(planet, player).open(player);
                    break;
                }
                this.sendPlanetInfo((CommandSender)player, planet);
            }
        }
    }

    private void sendPlanetInfo(CommandSender sender, Planet planet) {
        long now = System.currentTimeMillis();
        sender.sendMessage(MessageUtils.getLocaleMessage("world.info").replace("%name%", planet.getInformation().getDisplayName()).replace("%id%", String.valueOf(planet.getId())).replace("%creation-time%", MessageUtils.getElapsedTime(now, planet.getCreationTime())).replace("%activity-time%", MessageUtils.getElapsedTime(now, planet.getLastActivityTime())).replace("%online%", String.valueOf(planet.getOnline())).replace("%builders%", planet.getWorldPlayers().getBuilders()).replace("%coders%", planet.getWorldPlayers().getDevelopers()).replace("%owner%", planet.getOwner()).replace("%sharing%", planet.getSharing().getName()).replace("%mode%", planet.getMode().getName()).replace("%description%", planet.getInformation().getDescription()));
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            WorldCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            WorldCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            WorldCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            WorldCommand.$$$reportNull$$$0(6);
        }
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        ArrayList<String> tabCompleter = new ArrayList<String>();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return null;
        }
        if (!planet.isOwner(player)) {
            return null;
        }
        if (args.length == 1) {
            tabCompleter.addAll(List.of(planet.getSharing() == Planet.Sharing.PUBLIC ? "close" : "open", "kick", "ban", "unban", "spawn", "setspawn", "whitelist", "unwhitelist"));
        } else if (args.length == 2) {
            if (List.of("unban", "unblacklist").contains(args[0].toLowerCase())) {
                tabCompleter.addAll(planet.getWorldPlayers().getBannedPlayers().stream().filter(p -> p.startsWith(args[1])).toList());
            } else if (List.of("unwhite", "unwhitelist").contains(args[0].toLowerCase())) {
                tabCompleter.addAll(planet.getWorldPlayers().getWhitelistedPlayers().stream().filter(p -> p.startsWith(args[1])).toList());
            } else if (List.of("ban", "blacklist", "kick", "whitelist", "white").contains(args[0].toLowerCase())) {
                if (args[0].equalsIgnoreCase("kick")) {
                    tabCompleter.add("*");
                }
                tabCompleter.addAll(planet.getPlayers().stream().filter(p -> !planet.isOwner((Player)p) && p.getName().startsWith(args[1])).map(Player::getName).toList());
            } else if (args[0].equalsIgnoreCase("platformer") && player.hasPermission("opencreative.world.set-platformer")) {
                tabCompleter.addAll(DevPlatformers.getInstance().getPlatformersIDs());
            }
        }
        return tabCompleter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/WorldCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

