/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world.modes;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.events.planet.PlanetModeChangeEvent;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class BuildCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            BuildCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            BuildCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            BuildCommand.$$$reportNull$$$0(2);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            if (planet == null) {
                player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                return;
            }
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            if (args.length == 0) {
                ChangedWorld.removePlayerWithLocation(player);
                if (planet.getMode() != Planet.Mode.BUILD) {
                    if (planet.getWorldPlayers().canBuild(player)) {
                        Player planetOwner = Bukkit.getPlayer((String)planet.getOwner());
                        if (!planet.getWorldPlayers().isTrustedBuilder(player)) {
                            if (planetOwner == null) {
                                sender.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.cant-build-when-offline"));
                                return;
                            }
                            Planet ownerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(planetOwner);
                            if (ownerPlanet != planet) {
                                sender.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.cant-build-when-offline"));
                                return;
                            }
                        }
                        PlanetModeChangeEvent event = new PlanetModeChangeEvent(planet, planet.getMode(), Planet.Mode.BUILD, player);
                        event.callEvent();
                        if (event.isCancelled()) {
                            return;
                        }
                        planet.setMode(Planet.Mode.BUILD);
                        if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                            PlayerUtils.clearPlayer(player);
                            player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                            if (planet.isOwner(sender.getName())) {
                                player.getInventory().setItem(8, ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings"));
                            }
                            planet.getTerritory().showBorders(player);
                            PlayerUtils.giveBuildPermissions(player);
                            player.setGameMode(GameMode.CREATIVE);
                        }
                    } else {
                        sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    }
                } else {
                    PlayerUtils.clearPlayer(player);
                    player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.build-mode.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.build-mode.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                    player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                    Sounds.WORLD_MODE_BUILD.play((Audience)player);
                    if (planet.getWorldPlayers().canBuild(player)) {
                        Player planetOwner = Bukkit.getPlayer((String)planet.getOwner());
                        if (planet.getWorldPlayers().getBuildersNotTrusted().contains(sender.getName())) {
                            if (planetOwner == null) {
                                sender.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.cant-build-when-offline"));
                                return;
                            }
                            Planet ownerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(planetOwner);
                            if (ownerPlanet != planet) {
                                sender.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.cant-build-when-offline"));
                                return;
                            }
                        }
                        if (planet.isOwner(sender.getName())) {
                            ItemStack worldSettingsItem = ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings");
                            player.getInventory().setItem(8, worldSettingsItem);
                        }
                        player.setGameMode(GameMode.CREATIVE);
                        planet.getTerritory().showBorders(player);
                        PlayerUtils.giveBuildPermissions(player);
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.message.owner"));
                        if (!planet.getTerritory().isAutoSave()) {
                            player.sendMessage(MessageUtils.getLocaleMessage("settings.autosave.warning"));
                        }
                    } else {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.message.players"));
                    }
                }
            } else {
                if (!planet.isOwner(sender.getName())) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                String nickname = args[0];
                Player onlinePlayer = Bukkit.getPlayer((String)nickname);
                if (!planet.getWorldPlayers().getAllBuilders().contains(nickname) && onlinePlayer != null) {
                    nickname = onlinePlayer.getName();
                }
                if (planet.isOwner(nickname)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("same-player"));
                    return;
                }
                if (planet.getWorldPlayers().getBuildersNotTrusted().contains(nickname)) {
                    planet.getWorldPlayers().addBuilder(nickname, true);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.trusted").replace("%player%", nickname));
                    return;
                }
                if (planet.getWorldPlayers().getBuildersTrusted().contains(nickname)) {
                    planet.getWorldPlayers().removeBuilder(nickname);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.removed").replace("%player%", nickname));
                    return;
                }
                int limit = planet.getLimits().getBuildersLimit();
                if (planet.getWorldPlayers().getAllBuilders().size() > limit) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.limit").replace("%limit%", String.valueOf(limit)));
                    return;
                }
                if (onlinePlayer != null) {
                    Planet playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(onlinePlayer);
                    if (planet.equals(playerPlanet)) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.added").replace("%player%", onlinePlayer.getName()));
                        planet.getWorldPlayers().addBuilder(onlinePlayer.getName(), false);
                    } else {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    }
                } else {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                }
            }
        }
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (sender == null) {
            BuildCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            BuildCommand.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            BuildCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            BuildCommand.$$$reportNull$$$0(6);
        }
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return null;
        }
        if (planet.isOwner(player)) {
            ArrayList<String> list = new ArrayList<String>(planet.getWorldPlayers().getAllBuilders());
            return list.subList(0, Math.min(10, list.size()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/modes/BuildCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

