/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world.modes;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.QuitEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class DevCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            DevCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            DevCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            DevCommand.$$$reportNull$$$0(2);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            if (planet == null) {
                player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                return;
            }
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            if (args.length == 0 || args.length == 3) {
                if (planet.getWorldPlayers().canDevelop(player) || planet.getWorldPlayers().isDeveloperGuest(player)) {
                    if (!planet.getWorldPlayers().isTrustedDeveloper(player)) {
                        Player planetOwner = Bukkit.getPlayer((String)planet.getOwner());
                        if (planetOwner == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("world.dev-mode.cant-dev-when-offline"));
                            return;
                        }
                        Planet ownerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(planetOwner);
                        if (!planet.equals(ownerPlanet)) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("world.dev-mode.cant-dev-when-offline"));
                            return;
                        }
                    }
                    new QuitEvent(player).callEvent();
                    PlayerInventory playerInventory = player.getInventory();
                    ItemStack[] playerInventoryItems = OpenCreative.getPlanetsManager().getDevPlanet(player) == null ? playerInventory.getContents() : new ItemStack[]{};
                    PlayerUtils.clearPlayer(player);
                    sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.dev-mode.help", (OfflinePlayer)player));
                    if (args.length == 3) {
                        try {
                            double x = Double.parseDouble(args[0]);
                            double y = Double.parseDouble(args[1]);
                            double z = Double.parseDouble(args[2]);
                            planet.connectToDevPlanet(player, x, y, z);
                        }
                        catch (Exception error) {
                            planet.connectToDevPlanet(player);
                        }
                    } else {
                        planet.connectToDevPlanet(player);
                    }
                    if (planet.getWorldPlayers().isDeveloperGuest(player)) {
                        player.setGameMode(GameMode.ADVENTURE);
                        player.setAllowFlight(true);
                        player.setFlying(true);
                    } else {
                        player.setGameMode(GameMode.CREATIVE);
                        player.setAllowFlight(true);
                        player.setFlying(true);
                        PlayerUtils.giveDevPermissions(player);
                    }
                    ItemStack worldSettingsItem = ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings");
                    if (planet.isOwner(player)) {
                        player.getInventory().setItem(8, worldSettingsItem);
                    }
                    this.giveItems(player);
                    for (ItemStack item : playerInventoryItems) {
                        if (item == null || ItemUtils.itemEquals(item, worldSettingsItem) || player.getInventory().containsAtLeast(item, 1)) continue;
                        player.getInventory().addItem(new ItemStack[]{item});
                    }
                } else {
                    sender.sendMessage(MessageUtils.getPlayerLocaleMessage("not-owner", (OfflinePlayer)player));
                }
            } else {
                if (!planet.isOwner(sender.getName())) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                String nickname = args[0];
                Player onlinePlayer = Bukkit.getPlayer((String)nickname);
                if (!planet.getWorldPlayers().getAllDevelopers().contains(nickname) && onlinePlayer != null) {
                    nickname = onlinePlayer.getName();
                }
                if (planet.isOwner(nickname)) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("same-player"));
                    return;
                }
                if (planet.getWorldPlayers().getDevelopersNotTrusted().contains(nickname)) {
                    planet.getWorldPlayers().addDeveloper(nickname, true);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.trusted").replace("%player%", nickname));
                    return;
                }
                if (planet.getWorldPlayers().getDevelopersTrusted().contains(nickname)) {
                    planet.getWorldPlayers().removeDeveloper(nickname);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.removed").replace("%player%", nickname));
                    return;
                }
                int limit = planet.getLimits().getDevelopersLimit();
                if (planet.getWorldPlayers().getAllDevelopers().size() > limit) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.limit").replace("%limit%", String.valueOf(limit)));
                    return;
                }
                if (onlinePlayer != null) {
                    Planet playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(onlinePlayer);
                    if (planet.equals(playerPlanet)) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.added").replace("%player%", onlinePlayer.getName()));
                        planet.getWorldPlayers().addDeveloper(onlinePlayer.getName(), false);
                    } else {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    }
                } else {
                    sender.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                }
            }
        }
    }

    private void giveItems(Player player) {
        PlayerInventory inventory = player.getInventory();
        inventory.setHeldItemSlot(0);
        this.setItemIfAbsent((Inventory)inventory, 0, ExecutorCategory.EVENT_PLAYER.getItem());
        this.setItemIfAbsent((Inventory)inventory, 1, ActionCategory.PLAYER_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 2, ActionCategory.PLAYER_CONDITION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 3, ActionCategory.ELSE_CONDITION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 9, ExecutorCategory.CYCLE.getItem());
        this.setItemIfAbsent((Inventory)inventory, 10, ActionCategory.REPEAT_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 11, ActionCategory.CONTROLLER_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 12, ActionCategory.CONTROL_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 13, ActionCategory.VARIABLE_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 14, ActionCategory.VARIABLE_CONDITION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 18, ExecutorCategory.EVENT_WORLD.getItem());
        this.setItemIfAbsent((Inventory)inventory, 19, ActionCategory.WORLD_CONDITION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 20, ActionCategory.WORLD_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 21, ExecutorCategory.METHOD.getItem());
        this.setItemIfAbsent((Inventory)inventory, 22, ActionCategory.LAUNCH_METHOD_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 23, ActionCategory.SELECTION_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 27, ExecutorCategory.EVENT_ENTITY.getItem());
        this.setItemIfAbsent((Inventory)inventory, 28, ActionCategory.ENTITY_CONDITION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 29, ActionCategory.ENTITY_ACTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 30, ExecutorCategory.FUNCTION.getItem());
        this.setItemIfAbsent((Inventory)inventory, 31, ActionCategory.LAUNCH_FUNCTION_ACTION.getItem());
        ItemStack linesControllerItem = ItemUtils.createItem(Material.COMPARATOR, 1, "items.developer.lines-controller");
        this.setItemIfAbsent((Inventory)inventory, 26, linesControllerItem);
        ItemStack arrowNotItem = ItemUtils.createItem(Material.ARROW, 1, "items.developer.arrow-not");
        this.setItemIfAbsent((Inventory)inventory, 35, arrowNotItem);
        int slot = 8;
        if (inventory.getItem(8) != null) {
            slot = 7;
        }
        ItemStack bookHelperItem = ItemUtils.createItem(Material.WRITTEN_BOOK, 1, "items.developer.coding-book");
        BookMeta bookMeta = (BookMeta)bookHelperItem.getItemMeta();
        bookMeta.setTitle("Coding");
        bookMeta.setAuthor("OpenCreative+");
        bookMeta.setPages(MessageUtils.getBookPages("items.developer.coding-book.pages"));
        bookHelperItem.setItemMeta((ItemMeta)bookMeta);
        this.setItemIfAbsent((Inventory)inventory, slot == 8 ? slot - 1 : 17, bookHelperItem);
        ItemStack flySpeedChangerItem = ItemUtils.createItem(Material.FEATHER, 1, "items.developer.fly-speed-changer");
        this.setItemIfAbsent((Inventory)inventory, slot == 8 ? 17 : 16, flySpeedChangerItem);
        this.setItemIfAbsent((Inventory)inventory, slot, ItemUtils.createItem(Material.IRON_INGOT, 1, "items.developer.variables"));
    }

    private void setItemIfAbsent(@NotNull Inventory inventory, int slot, @NotNull ItemStack item) {
        if (inventory == null) {
            DevCommand.$$$reportNull$$$0(3);
        }
        if (item == null) {
            DevCommand.$$$reportNull$$$0(4);
        }
        if (!inventory.contains(item, 1)) {
            inventory.setItem(slot, item);
        }
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (sender == null) {
            DevCommand.$$$reportNull$$$0(5);
        }
        if (command == null) {
            DevCommand.$$$reportNull$$$0(6);
        }
        if (alias == null) {
            DevCommand.$$$reportNull$$$0(7);
        }
        if (args == null) {
            DevCommand.$$$reportNull$$$0(8);
        }
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return null;
        }
        if (planet.isOwner(player)) {
            ArrayList<String> list = new ArrayList<String>(planet.getWorldPlayers().getAllDevelopers());
            return list.subList(0, Math.min(10, list.size()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inventory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/modes/DevCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setItemIfAbsent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

