/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world.modes;

import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.CodingBlockParser;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.JoinEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.PlayEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.QuitEvent;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.events.planet.PlanetModeChangeEvent;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class PlayCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            PlayCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            PlayCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            PlayCommand.$$$reportNull$$$0(2);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            if (planet == null) {
                player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                return;
            }
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            DevPlanet playerDevPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
            if (playerDevPlanet != null) {
                playerDevPlanet.getLastLocations().put(player, player.getLocation());
            }
            ChangedWorld.removePlayerWithLocation(player);
            if (planet.getMode() != Planet.Mode.PLAYING) {
                if (planet.getWorldPlayers().canDevelop(player)) {
                    PlanetModeChangeEvent event = new PlanetModeChangeEvent(planet, planet.getMode(), Planet.Mode.PLAYING, player);
                    event.callEvent();
                    if (event.isCancelled()) {
                        return;
                    }
                    if (!OpenCreative.getStability().isFine()) {
                        player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
                        Sounds.PLAYER_FAIL.play((Audience)player);
                        return;
                    }
                    planet.setMode(Planet.Mode.PLAYING);
                    if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                        PlayerUtils.clearPlayer(player);
                        player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                        planet.getTerritory().showBorders(player);
                        if (planet.isOwner(sender.getName())) {
                            player.getInventory().setItem(8, ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings"));
                        }
                        PlayerUtils.givePlayPermissions(player);
                        new JoinEvent(player).callEvent();
                    }
                } else {
                    sender.sendMessage(MessageUtils.getPlayerLocaleMessage("not-owner", (OfflinePlayer)player));
                }
            } else if (!new PlayEvent(player).callEvent() || planet.getWorldPlayers().canDevelop(player)) {
                if (planet.getWorldPlayers().canDevelop(player)) {
                    if (!OpenCreative.getStability().isFine()) {
                        player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
                        Sounds.PLAYER_FAIL.play((Audience)player);
                    } else {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.play-mode.message.owner"));
                        if (!Arrays.asList(args).contains("--no-compile")) {
                            if (planet.getDevPlanet().isLoaded()) {
                                new CodingBlockParser(planet.getDevPlanet()).parseCode(planet.getDevPlanet());
                            } else {
                                planet.getTerritory().getScript().loadCode();
                            }
                        }
                    }
                } else {
                    player.sendMessage(MessageUtils.getLocaleMessage("world.play-mode.message.players"));
                }
                planet.getTerritory().getWorld().getSpawnLocation().getChunk().load(true);
                DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                if (devPlanet != null) {
                    PlayerUtils.clearPlayer(player);
                } else {
                    new QuitEvent(player).callEvent();
                }
                PlayerUtils.clearPlayer(player);
                player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                planet.getTerritory().showBorders(player);
                if (planet.isOwner(sender.getName())) {
                    player.getInventory().setItem(8, ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings"));
                }
                if (planet.getWorldPlayers().canDevelop(player)) {
                    PlayerUtils.givePlayPermissions(player);
                }
                new JoinEvent(player).callEvent();
            }
        }
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            PlayCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            PlayCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            PlayCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            PlayCommand.$$$reportNull$$$0(6);
        }
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return null;
        }
        if (planet.getMode() == Planet.Mode.PLAYING && planet.getWorldPlayers().canDevelop(player) && args.length <= 1) {
            return List.of("--no-compile");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/modes/PlayCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

