/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.indev;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ItemBuilder {
    private final ItemStack item;

    public ItemBuilder(ItemStack item) {
        this.item = item.clone();
    }

    public ItemBuilder(Material material) {
        this.item = ItemUtils.createItem(material, 1);
    }

    public ItemBuilder translate(String path) {
        this.item.editMeta(meta -> {
            meta.setDisplayName(MessageUtils.getLocaleItemName(path + ".name"));
            meta.setLore(MessageUtils.getLocaleItemDescription(path + ".lore"));
        });
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder data(NamespacedKey key, String value) {
        ItemUtils.setPersistentData(this.item, key, value);
        return this;
    }

    public ItemBuilder type(String value) {
        ItemUtils.setPersistentData(this.item, ItemUtils.getItemTypeKey(), value);
        return this;
    }

    public ItemBuilder parse(String placeholder, Object value) {
        ItemUtils.replacePlaceholderInName(this.item, placeholder, value);
        ItemUtils.replacePlaceholderInLore(this.item, placeholder, value);
        return this;
    }

    public ItemStack getItem() {
        return this.item;
    }
}

