/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.indev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Since;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;

public class OfflineWander {
    @Since(value=5.6)
    @NotNull
    protected final UUID uuid;
    @Since(value=5.6)
    @Nullable
    protected String name;
    @Since(value=5.6)
    @Nullable
    protected String description;
    @Since(value=5.6)
    @Nullable
    protected Gender gender;
    @Since(value=5.6)
    @Nullable
    protected List<Integer> favoriteWorlds;
    @Since(value=5.6)
    protected int lastPlayedWorldId;
    @Since(value=5.6)
    protected boolean hideHints;

    public OfflineWander(@NotNull UUID uuid) {
        if (uuid == null) {
            OfflineWander.$$$reportNull$$$0(0);
        }
        this.lastPlayedWorldId = -1;
        this.uuid = uuid;
        this.loadInfo();
    }

    public OfflineWander(@NotNull OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null) {
            OfflineWander.$$$reportNull$$$0(1);
        }
        this.lastPlayedWorldId = -1;
        this.uuid = offlinePlayer.getUniqueId();
        this.loadInfo();
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public boolean isOnline() {
        return Bukkit.getPlayer((UUID)this.uuid) != null;
    }

    @NotNull
    public UUID getUniqueId() {
        UUID uUID = this.uuid;
        if (uUID == null) {
            OfflineWander.$$$reportNull$$$0(2);
        }
        return uUID;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Gender getGender() {
        return this.gender;
    }

    public int getLastPlayedWorldId() {
        return this.lastPlayedWorldId;
    }

    public boolean isHideHints() {
        return this.hideHints;
    }

    @NotNull
    public List<Integer> getFavoriteWorlds() {
        List<Integer> list = this.favoriteWorlds != null ? this.favoriteWorlds : List.of();
        if (list == null) {
            OfflineWander.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setLastPlayedWorldId(int lastPlayedWorldId) {
        this.lastPlayedWorldId = lastPlayedWorldId;
        this.saveData();
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            OfflineWander.$$$reportNull$$$0(4);
        }
        this.name = name;
        this.saveData();
    }

    public void setDescription(@NotNull String description) {
        if (description == null) {
            OfflineWander.$$$reportNull$$$0(5);
        }
        this.description = description;
        this.saveData();
    }

    public void addFavoriteWorld(int worldId) {
        this.getFavoriteWorlds().add(worldId);
        this.saveData();
    }

    public void removeFavoriteWorld(int worldId) {
        this.getFavoriteWorlds().remove(worldId);
        this.saveData();
    }

    public void setGender(@NotNull Gender gender) {
        if (gender == null) {
            OfflineWander.$$$reportNull$$$0(6);
        }
        this.gender = gender;
        this.saveData();
    }

    public void clearData() {
        File jsonFile = FileUtils.getWanderJsonFile(this, false);
        if (jsonFile == null || !jsonFile.exists()) {
            return;
        }
        this.name = null;
        this.description = null;
        this.gender = null;
        this.lastPlayedWorldId = -1;
        this.getFavoriteWorlds().clear();
        try {
            jsonFile.delete();
        }
        catch (Exception error) {
            ErrorUtils.sendDebugError("Can't delete wander file: " + String.valueOf(this.uuid), error);
        }
    }

    public void loadInfo() {
        File jsonFile = FileUtils.getWanderJsonFile(this, false);
        if (jsonFile == null || !jsonFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(jsonFile);){
            Gson gson = new Gson();
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (json.has("name")) {
                this.name = json.get("name").getAsString();
            }
            if (json.has("description")) {
                this.description = json.get("description").getAsString();
            }
            if (json.has("gender")) {
                this.gender = Gender.getGender(json.get("gender").getAsString());
            }
            if (json.has("favoriteWorlds")) {
                JsonArray arr = json.getAsJsonArray("favoriteWorlds");
                this.favoriteWorlds = new ArrayList<Integer>();
                for (JsonElement el : arr) {
                    this.favoriteWorlds.add(el.getAsInt());
                }
            }
            if (json.has("lastPlayedWorldId")) {
                this.lastPlayedWorldId = json.get("lastPlayedWorldId").getAsInt();
            }
            if (json.has("hideHints")) {
                this.hideHints = json.get("hideHints").getAsBoolean();
            }
        }
        catch (Exception error) {
            ErrorUtils.sendDebugError("Failed to load info for wander " + String.valueOf(this.uuid), error);
        }
    }

    public void saveData() {
        try {
            if (!this.shouldSaveData()) {
                return;
            }
            File jsonFile = FileUtils.getWanderJsonFile(this, true);
            if (jsonFile == null) {
                return;
            }
            JsonObject json = this.getJsonObject();
            try (FileWriter writer = new FileWriter(jsonFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (Exception error) {
            ErrorUtils.sendDebugError("Failed to save wander data: " + String.valueOf(this.uuid), error);
        }
    }

    private boolean shouldSaveData() {
        return this.favoriteWorlds != null || this.description != null || this.gender != null || this.lastPlayedWorldId != -1;
    }

    private JsonObject getJsonObject() {
        JsonObject json = new JsonObject();
        json.addProperty("uuid", this.uuid.toString());
        if (this.name != null) {
            json.addProperty("name", this.name);
        }
        if (this.description != null) {
            json.addProperty("description", this.description);
        }
        if (this.gender != null) {
            json.addProperty("gender", this.gender.name());
        }
        JsonArray favoriteWorlds = new JsonArray();
        if (this.favoriteWorlds != null) {
            for (int id : this.favoriteWorlds) {
                favoriteWorlds.add((Number)id);
            }
        }
        if (!favoriteWorlds.isEmpty()) {
            json.add("favoriteWorlds", (JsonElement)favoriteWorlds);
        }
        if (this.lastPlayedWorldId != -1) {
            json.addProperty("lastPlayedWorldId", (Number)this.lastPlayedWorldId);
        }
        if (this.hideHints) {
            json.addProperty("hideHints", Boolean.valueOf(true));
        }
        return json;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OfflineWander) {
            OfflineWander wander = (OfflineWander)obj;
            return this.uuid.equals(wander.uuid);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return this.uuid.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlinePlayer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/indev/OfflineWander";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/indev/OfflineWander";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteWorlds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setGender";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static enum Gender {
        MALE,
        FEMALE,
        OTHER;


        @NotNull
        public static Gender getGender(@NotNull String text) {
            if (text == null) {
                Gender.$$$reportNull$$$0(0);
            }
            for (Gender gender : Gender.values()) {
                if (!gender.name().equalsIgnoreCase(text)) continue;
                Gender gender2 = gender;
                if (gender2 == null) {
                    Gender.$$$reportNull$$$0(1);
                }
                return gender2;
            }
            Gender gender = OTHER;
            if (gender == null) {
                Gender.$$$reportNull$$$0(2);
            }
            return gender;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ua/mcchickenstudio/opencreative/indev/OfflineWander$Gender";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ua/mcchickenstudio/opencreative/indev/OfflineWander$Gender";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGender";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getGender";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

