/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class BucketListener
implements Listener {
    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        if (devPlanet != null) {
            event.setCancelled(true);
        } else if (PlayerUtils.isEntityInLobby((Entity)player) && OpenCreative.getSettings().isLobbyDisallowPlacingBlocks() && !player.hasPermission("opencreative.lobby.placing-blocks.bypass")) {
            event.setCancelled(true);
            player.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
        }
    }

    @EventHandler
    public void onBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtils.isEntityInLobby((Entity)player) && OpenCreative.getSettings().isLobbyDisallowDestroyingBlocks() && !player.hasPermission("opencreative.lobby.destroying-blocks.bypass")) {
            event.setCancelled(true);
            player.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
        }
    }
}

