/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.ChatEvent;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.coding.modules.ModuleSettingsMenu;
import ua.mcchickenstudio.opencreative.events.player.WorldChatEvent;
import ua.mcchickenstudio.opencreative.menus.world.browsers.WorldsBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsPlayersMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ColorUtils;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerConfirmation;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class ChatListener
implements Listener {
    public static final Map<Player, PlayerConfirmation> confirmation = new HashMap<Player, PlayerConfirmation>();

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        String message = LegacyComponentSerializer.legacyAmpersand().serialize(event.message());
        try {
            Player player = event.getPlayer();
            if (message.startsWith("!")) {
                if (event.isCancelled()) {
                    return;
                }
                String creativeChatCommand = "cc " + message.replaceFirst("!", "");
                Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> player.performCommand(creativeChatCommand));
                event.setCancelled(true);
                return;
            }
            this.checkDevItems(player, message);
            this.checkConfirmation(player, message);
            if (event.isCancelled()) {
                return;
            }
            event.setCancelled(true);
            if (CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.WORLD_CHAT) > 0) {
                player.sendMessage(MessageUtils.getLocaleMessage("world.chat-cooldown").replace("%cooldown%", String.valueOf(CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.WORLD_CHAT))));
                return;
            }
            CooldownUtils.setCooldown(player, OpenCreative.getSettings().getGroups().getGroup(player).getChatCooldown(), CooldownUtils.CooldownType.WORLD_CHAT);
            String formatted = ChatColor.translateAlternateColorCodes((char)'&', (String)MessageUtils.parsePAPI((OfflinePlayer)player, OpenCreative.getPlugin().getConfig().getString("messages.world-chat")).replace("%player%", player.getName()).replace("%message%", message));
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            WorldChatEvent creativeEvent = new WorldChatEvent(player, message, formatted, player.getWorld(), planet);
            Bukkit.getScheduler().runTaskLater((Plugin)OpenCreative.getPlugin(), () -> {
                creativeEvent.callEvent();
                if (creativeEvent.isCancelled()) {
                    return;
                }
                String finalMessage = creativeEvent.getFormattedMessage();
                if (planet != null) {
                    DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                    if (devPlanet != null) {
                        for (Player p : devPlanet.getWorld().getPlayers()) {
                            p.sendMessage(finalMessage);
                        }
                        for (Player p : planet.getTerritory().getWorld().getPlayers()) {
                            if (!planet.getWorldPlayers().canDevelop(p)) continue;
                            p.sendMessage(finalMessage);
                        }
                        OpenCreative.getPlugin().getLogger().info("[WORLD-CHAT: " + planet.getId() + "dev] " + player.getName() + ": " + message);
                    } else {
                        ChatEvent chatEvent = new ChatEvent(event.getPlayer(), message);
                        chatEvent.callEvent();
                        if (chatEvent.isCancelled()) {
                            event.setCancelled(true);
                            return;
                        }
                        if (planet.getPlayers().size() == 1 && !chatEvent.isHandledByCode()) {
                            player.sendMessage(MessageUtils.getLocaleComponent("chat-no-near-players", (OfflinePlayer)player).clickEvent(ClickEvent.suggestCommand((String)("!" + message))));
                        }
                        for (Player p : planet.getPlayers()) {
                            p.sendMessage(finalMessage);
                        }
                        OpenCreative.getPlugin().getLogger().info("[WORLD-CHAT: " + planet.getId() + "] " + player.getName() + ": " + message);
                    }
                } else {
                    if (player.getWorld().getPlayers().size() == 1) {
                        player.sendMessage(MessageUtils.getLocaleComponent("chat-no-near-players", (OfflinePlayer)player).clickEvent(ClickEvent.suggestCommand((String)("!" + message))));
                    }
                    for (Player p : player.getWorld().getPlayers()) {
                        p.sendMessage(finalMessage);
                    }
                    OpenCreative.getPlugin().getLogger().info("[WORLD-CHAT: " + player.getWorld().getName() + "] " + player.getName() + ": " + message);
                }
            }, 1L);
        }
        catch (Exception error) {
            event.setCancelled(true);
            ErrorUtils.sendPlayerErrorMessage(event.getPlayer(), "Can't handle chat message: " + message, error);
        }
    }

    private void checkDevItems(Player player, String message) {
        if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand.getType() == Material.BOOK) {
                ItemMeta meta = itemInHand.getItemMeta();
                TextComponent newName = LegacyComponentSerializer.legacyAmpersand().deserialize(message.replace("%space%", " "));
                meta.displayName((Component)newName);
                itemInHand.setItemMeta(meta);
                Sounds.DEV_TEXT_SET.play((Audience)player);
                ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingValueKey(), "TEXT");
                player.getInventory().setItemInMainHand(itemInHand);
                player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)meta.displayName(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                player.swingMainHand();
            } else if (itemInHand.getType() == Material.SLIME_BALL) {
                String numberString = ChatColor.stripColor((String)message);
                if (numberString.equalsIgnoreCase("p") || numberString.equalsIgnoreCase("pi")) {
                    numberString = "3.1415926";
                }
                try {
                    double number = MessageUtils.parseTicks(numberString);
                    ItemMeta meta = itemInHand.getItemMeta();
                    meta.setDisplayName("\u00a7a" + number);
                    itemInHand.setItemMeta(meta);
                    ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingValueKey(), "NUMBER");
                    Sounds.DEV_NUMBER_SET.play((Audience)player);
                    player.setItemInHand(itemInHand);
                    player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)meta.displayName(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                    player.swingMainHand();
                }
                catch (NumberFormatException exception) {
                    player.showTitle(Title.title((Component)Component.empty(), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable-number-error")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                }
            } else if (itemInHand.getType() == Material.MAGMA_CREAM) {
                String itemName;
                StringBuilder newValue = new StringBuilder(ChatColor.stripColor((String)message));
                ItemMeta meta = itemInHand.getItemMeta();
                char insert = 'c';
                if (itemInHand.hasItemMeta() && (itemName = meta.getDisplayName()).length() >= 2) {
                    insert = itemName.charAt(1);
                }
                newValue.insert(0, ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + insert)));
                meta.setDisplayName(newValue.toString());
                itemInHand.setItemMeta(meta);
                ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingValueKey(), "VARIABLE");
                ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingVariableTypeKey(), insert == 'a' ? "SAVED" : (insert == 'e' ? "GLOBAL" : "LOCAL"));
                Sounds.DEV_VARIABLE_SET.play((Audience)player);
                player.getInventory().setItemInMainHand(itemInHand);
                player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)meta.displayName(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                player.swingMainHand();
            } else if (itemInHand.getType() == Material.BLACK_DYE) {
                int[] rgbColor = ColorUtils.parseRGB(message);
                int red = rgbColor[0];
                int green = rgbColor[1];
                int blue = rgbColor[2];
                ItemMeta meta = itemInHand.getItemMeta();
                if (meta != null) {
                    meta.displayName(Component.text((String)(red + " " + green + " " + blue)).color(TextColor.color((int)red, (int)green, (int)blue)));
                    itemInHand.setItemMeta(meta);
                }
                ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingValueKey(), "COLOR");
                player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)meta.displayName(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                Sounds.DEV_VALUE_SET.play((Audience)player);
                player.getInventory().setItemInMainHand(itemInHand);
                player.swingMainHand();
            } else if (itemInHand.getType() == Material.POTION || itemInHand.getType() == Material.LINGERING_POTION || itemInHand.getType() == Material.SPLASH_POTION) {
                ItemMeta red = itemInHand.getItemMeta();
                if (!(red instanceof PotionMeta)) {
                    return;
                }
                PotionMeta oldMeta = (PotionMeta)red;
                ArrayList effects = new ArrayList();
                if (oldMeta.hasCustomEffects()) {
                    effects.addAll(oldMeta.getCustomEffects());
                    oldMeta.clearCustomEffects();
                }
                if (oldMeta.getBasePotionType() != null) {
                    effects.addAll(oldMeta.getBasePotionType().getPotionEffects());
                }
                if (effects.isEmpty()) {
                    return;
                }
                message = ChatColor.stripColor((String)message);
                int amplifier = 1;
                int duration = 1200;
                int effectNumber = 1;
                String[] potionDataList = new String[3];
                if (message.contains(", ")) {
                    potionDataList = message.split(", ");
                } else if (message.contains(" ")) {
                    potionDataList = message.split(" ");
                } else {
                    potionDataList[0] = message;
                }
                if (potionDataList.length >= 1) {
                    try {
                        duration = Double.valueOf(MessageUtils.parseTicks(potionDataList[0])).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (potionDataList.length >= 2) {
                    try {
                        amplifier = Integer.parseInt(potionDataList[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (potionDataList.length >= 3) {
                    try {
                        effectNumber = Integer.parseInt(potionDataList[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (effectNumber < 1) {
                    effectNumber = 1;
                }
                PotionEffect effect = (PotionEffect)effects.get(effectNumber > effects.size() ? 0 : effectNumber - 1);
                PotionMeta newMeta = (PotionMeta)new ItemStack(Material.POTION, 1).getItemMeta();
                for (PotionEffect oldEffect : effects) {
                    newMeta.addCustomEffect(oldEffect, true);
                }
                newMeta.addCustomEffect(new PotionEffect(effect.getType(), duration, amplifier - 1), true);
                player.showTitle(Title.title((Component)Component.empty(), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-potion").replace("%duration%", MessageUtils.convertTime((long)duration * 50L)).replace("%amplifier%", "" + amplifier)), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(500L))));
                Sounds.DEV_POTION_SET.play((Audience)player);
                itemInHand.setItemMeta((ItemMeta)newMeta);
            } else if (itemInHand.getType() == Material.PRISMARINE_SHARD) {
                ItemMeta meta = itemInHand.getItemMeta();
                if (meta == null) {
                    return;
                }
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                String[] coordinates = (message = ChatColor.stripColor((String)message)).contains(", ") ? message.split(", ") : (message.contains(" ") ? message.split(" ") : new String[]{message});
                try {
                    x = Double.parseDouble(coordinates[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (coordinates.length >= 2) {
                    try {
                        y = Double.parseDouble(coordinates[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (coordinates.length >= 3) {
                    try {
                        z = Double.parseDouble(coordinates[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                meta.setDisplayName("\u00a7b" + x + " " + y + " " + z);
                itemInHand.setItemMeta(meta);
                ItemUtils.setPersistentData(itemInHand, ItemUtils.getCodingValueKey(), "VECTOR");
                player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)meta.displayName(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(500L))));
                Sounds.DEV_VECTOR_SET.play((Audience)player);
                player.swingMainHand();
            }
        }
    }

    private void checkConfirmation(Player player, String input) {
        if (confirmation.isEmpty()) {
            return;
        }
        if (!confirmation.containsKey(player)) {
            return;
        }
        PlayerConfirmation confirm = confirmation.get(player);
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        player.clearTitle();
        confirmation.remove(player);
        switch (confirm) {
            case WORLD_NAME_CHANGE: {
                if (planet == null || !planet.isOwner(player)) {
                    return;
                }
                String newName = "\u00a7f" + ChatColor.translateAlternateColorCodes((char)'&', (String)input);
                String uncoloredName = ChatColor.stripColor((String)newName);
                if (uncoloredName.length() > OpenCreative.getSettings().getWorldNameMaxLength() || uncoloredName.length() < OpenCreative.getSettings().getWorldNameMinLength()) {
                    player.sendMessage(MessageUtils.getLocaleMessage("settings.world-name.error").replace("%min%", String.valueOf(OpenCreative.getSettings().getWorldNameMinLength())).replace("%max%", String.valueOf(OpenCreative.getSettings().getWorldNameMaxLength())));
                    return;
                }
                planet.getInformation().setDisplayName(newName);
                player.sendMessage(MessageUtils.getLocaleMessage("settings.world-name.changed").replace("%name%", newName));
                planet.getInformation().updateIconAsync();
                break;
            }
            case WORLD_CUSTOM_ID_CHANGE: {
                if (planet == null || !planet.isOwner(player)) {
                    return;
                }
                String pattern = OpenCreative.getSettings().getCustomIdPattern();
                if (input.length() > OpenCreative.getSettings().getCustomIdMaxLength() || input.length() < OpenCreative.getSettings().getCustomIdMinLength() || Character.isDigit(input.charAt(0)) || !input.matches(pattern)) {
                    player.sendMessage(MessageUtils.getLocaleMessage("settings.world-id.error").replace("%min%", String.valueOf(OpenCreative.getSettings().getCustomIdMinLength())).replace("%max%", String.valueOf(OpenCreative.getSettings().getCustomIdMaxLength())));
                    return;
                }
                for (Planet searchablePlanet : OpenCreative.getPlanetsManager().getPlanets()) {
                    if (!searchablePlanet.getInformation().getCustomID().equalsIgnoreCase(input)) continue;
                    player.sendMessage(MessageUtils.getLocaleMessage("settings.world-id.taken"));
                    return;
                }
                planet.getInformation().setCustomID(input);
                player.sendMessage(MessageUtils.getLocaleMessage("settings.world-id.changed").replace("%id%", input));
                planet.getInformation().updateIconAsync();
                break;
            }
            case WORLD_DESCRIPTION_CHANGE: {
                if (planet == null || !planet.isOwner(player)) {
                    return;
                }
                Object newDescription = "\u00a7f" + ChatColor.translateAlternateColorCodes((char)'&', (String)input);
                String uncoloredDescription = ChatColor.stripColor((String)newDescription);
                if (uncoloredDescription.length() > OpenCreative.getSettings().getWorldDescriptionMaxLength() || uncoloredDescription.length() < OpenCreative.getSettings().getWorldDescriptionMinLength()) {
                    player.sendMessage(MessageUtils.getLocaleMessage("settings.world-description.error").replace("%min%", String.valueOf(OpenCreative.getSettings().getWorldDescriptionMinLength())).replace("%max%", String.valueOf(OpenCreative.getSettings().getWorldDescriptionMaxLength())));
                    return;
                }
                newDescription = String.join((CharSequence)"\\n", ChatListener.splitDescription((String)newDescription, 39));
                planet.getInformation().setDescription((String)newDescription);
                player.sendMessage(MessageUtils.getLocaleMessage("settings.world-description.changed").replace("%description%", (CharSequence)newDescription));
                planet.getInformation().updateIconAsync();
                break;
            }
            case FIND_PLANETS_BY_NAME: {
                Set<Planet> foundPlanetsByName = OpenCreative.getPlanetsManager().getPlanetsContainingName(input);
                if (!foundPlanetsByName.isEmpty()) {
                    Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> new WorldsBrowserMenu(player, foundPlanetsByName).open(player));
                    break;
                }
                player.sendMessage(MessageUtils.getLocaleMessage("menus.all-worlds.items.search.not-found"));
                break;
            }
            case FIND_PLANETS_BY_ID: {
                Set<Planet> foundPlanetsByID = OpenCreative.getPlanetsManager().getPlanetsContainingID(input);
                if (!foundPlanetsByID.isEmpty()) {
                    Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> new WorldsBrowserMenu(player, foundPlanetsByID).open(player));
                    break;
                }
                player.sendMessage(MessageUtils.getLocaleMessage("menus.all-worlds.items.search.not-found"));
                break;
            }
            case FIND_PLANETS_BY_OWNER: {
                Set<Planet> foundPlanets = OpenCreative.getPlanetsManager().getPlanetsByOwner(input);
                if (!foundPlanets.isEmpty()) {
                    Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> new WorldsBrowserMenu(player, foundPlanets).open(player));
                    break;
                }
                player.sendMessage(MessageUtils.getLocaleMessage("menus.all-worlds.items.search.not-found"));
                break;
            }
            case TRANSFER_OWNERSHIP: {
                if (planet == null || WorldSettingsPlayersMenu.playersSelected.get(player) == null || !planet.isOwner(player)) break;
                if (input.equals(String.valueOf(planet.getId()))) {
                    String newOwner = WorldSettingsPlayersMenu.playersSelected.get(player);
                    Player newOwnerPlayer = Bukkit.getPlayer((String)newOwner);
                    if (newOwnerPlayer == null) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.offline").replace("%player%", newOwner));
                        return;
                    }
                    if (!planet.getPlayers().contains(newOwnerPlayer)) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.offline").replace("%player%", newOwner));
                        return;
                    }
                    if (OpenCreative.getPlanetsManager().getPlanetsByOwner(newOwnerPlayer).size() >= OpenCreative.getSettings().getGroups().getGroup(newOwnerPlayer).getWorldsLimit()) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.limit").replace("%player%", newOwner));
                        return;
                    }
                    planet.setChangingOwner(true);
                    player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.awaiting").replace("%player%", newOwner));
                    newOwnerPlayer.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.confirm-new").replace("%player%", player.getName()).replace("%id%", String.valueOf(planet.getId())));
                    confirmation.put(newOwnerPlayer, PlayerConfirmation.GET_OWNERSHIP);
                    break;
                }
                player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.wrong-id"));
                break;
            }
            case GET_OWNERSHIP: {
                if (planet == null) break;
                Player oldOwner = Bukkit.getPlayer((String)planet.getOwner());
                if (input.equals(String.valueOf(planet.getId()))) {
                    if (oldOwner == null) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.offline").replace("%player%", player.getName()));
                        return;
                    }
                    if (!planet.getPlayers().contains(oldOwner)) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.offline").replace("%player%", player.getName()));
                        return;
                    }
                    if (OpenCreative.getPlanetsManager().getPlanetsByOwner(player).size() >= OpenCreative.getSettings().getGroups().getGroup(player).getWorldsLimit()) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.limit").replace("%player%", player.getName()));
                        return;
                    }
                    oldOwner.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.transferred-old").replace("%player%", player.getName()));
                    player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.transferred-new"));
                    planet.setChangingOwner(false);
                    Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> {
                        planet.setOwner(player.getName());
                        planet.getWorldPlayers().removeBuilder(player.getName());
                        planet.getWorldPlayers().removeDeveloper(player.getName());
                        Sounds.WORLD_SETTINGS_OWNER_SET.play((Audience)player);
                        ItemStack compass = ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings");
                        player.getInventory().setItem(8, compass);
                        oldOwner.getInventory().remove(compass);
                        oldOwner.setGameMode(GameMode.ADVENTURE);
                    });
                    break;
                }
                if (oldOwner != null) {
                    oldOwner.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.cancelled"));
                }
                player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.wrong-id"));
                planet.setChangingOwner(false);
                break;
            }
            case MODULE_NAME_CHANGE: {
                Module module = ModuleSettingsMenu.getCurrentEditingModule(player);
                ModuleSettingsMenu.removeFromCurrentEditing(player);
                if (module == null || !module.isOwner((OfflinePlayer)player)) {
                    return;
                }
                String newName = "\u00a7f" + ChatColor.translateAlternateColorCodes((char)'&', (String)input);
                String uncoloredName = ChatColor.stripColor((String)newName);
                if (uncoloredName.length() > OpenCreative.getSettings().getModuleNameMaxLength() || uncoloredName.length() < OpenCreative.getSettings().getModuleNameMinLength()) {
                    player.sendMessage(MessageUtils.getLocaleMessage("settings.module-name.error").replace("%min%", String.valueOf(OpenCreative.getSettings().getModuleNameMinLength())).replace("%max%", String.valueOf(OpenCreative.getSettings().getModuleNameMaxLength())));
                    return;
                }
                module.getInformation().setDisplayName(newName);
                player.sendMessage(MessageUtils.getLocaleMessage("settings.module-name.changed").replace("%name%", newName));
                break;
            }
            case MODULE_DESCRIPTION_CHANGE: {
                Module module = ModuleSettingsMenu.getCurrentEditingModule(player);
                ModuleSettingsMenu.removeFromCurrentEditing(player);
                if (module == null || !module.isOwner((OfflinePlayer)player)) {
                    return;
                }
                Object newDescription = "\u00a7f" + ChatColor.translateAlternateColorCodes((char)'&', (String)input);
                String uncoloredDescription = ChatColor.stripColor((String)newDescription);
                if (uncoloredDescription.length() > OpenCreative.getSettings().getModuleDescriptionMaxLength() || uncoloredDescription.length() < OpenCreative.getSettings().getModuleDescriptionMinLength()) {
                    player.sendMessage(MessageUtils.getLocaleMessage("settings.module-description.error").replace("%min%", String.valueOf(OpenCreative.getSettings().getModuleDescriptionMinLength())).replace("%max%", String.valueOf(OpenCreative.getSettings().getModuleDescriptionMaxLength())));
                    return;
                }
                newDescription = String.join((CharSequence)"\\n", ChatListener.splitDescription((String)newDescription, 39));
                module.getInformation().setDescription((String)newDescription);
                player.sendMessage(MessageUtils.getLocaleMessage("settings.module-description.changed").replace("%description%", (CharSequence)newDescription));
            }
        }
    }

    private static List<String> splitDescription(String input, int maxLength) {
        ArrayList<String> setDescriptionWords = new ArrayList<String>();
        if (input.contains("\\n")) {
            String[] newDescriptionWords = input.split("\\n");
            setDescriptionWords.addAll(Arrays.asList(newDescriptionWords));
        } else {
            String[] newDescriptionWords = input.split("\\s+");
            int currentSize = 0;
            StringBuilder newLine = new StringBuilder();
            if (newDescriptionWords.length > 1) {
                for (String word : newDescriptionWords) {
                    if (currentSize + word.length() > maxLength) {
                        if (word.length() > maxLength) {
                            String newStr = newLine.toString().replaceAll("(.{" + maxLength + "}[^\\n])", "$1\\\\n");
                            String[] newStrings = newStr.split("\\\\n");
                            setDescriptionWords.addAll(Arrays.asList(newStrings));
                        } else {
                            setDescriptionWords.add(newLine.toString().trim());
                        }
                        newLine = new StringBuilder();
                        currentSize = 0;
                    }
                    currentSize += word.length();
                    newLine.append(word).append(" ");
                }
            } else {
                input = input.replaceAll("(.{" + maxLength + "})", "$1\\\\n");
                String[] newStrings = input.split("\\\\n");
                setDescriptionWords.addAll(Arrays.asList(newStrings));
            }
            setDescriptionWords.add(newLine.toString().trim());
        }
        return setDescriptionWords;
    }
}

