/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.DamageBlockEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.DestroyBlockEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.listeners.player.PlaceBlockListener;
import ua.mcchickenstudio.opencreative.menus.Menus;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class DestroyBlockListener
implements Listener {
    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        if (devPlanet != null) {
            Block blockAtDown;
            Block block = event.getBlock();
            if (player.getInventory().getItemInMainHand().getType() == Material.COMPARATOR) {
                event.setCancelled(true);
                return;
            }
            DevPlatform platform = devPlanet.getPlatformInLocation(block.getLocation());
            if (platform == null) {
                event.setCancelled(true);
                return;
            }
            if (devPlanet.getIndestructibleBlocks().contains(block.getType()) || block.getType() == platform.getFloorMaterial() || block.getType() == platform.getEventMaterial() || block.getType() == platform.getActionMaterial() || block.getType() == Material.PISTON && block.getRelative(BlockFace.WEST).isSolid()) {
                Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                event.setCancelled(true);
            }
            if (devPlanet.getAllCodingBlocksForPlacing().contains(block.getType())) {
                if (ActionCategory.getByMaterial(block.getType()) != null) {
                    this.destroyAdditionalBlocks(platform, block, devPlanet.isDropItems());
                    block.setType(Material.AIR);
                    devPlanet.setCodeChanged(true);
                    PlaceBlockListener.move(block.getLocation(), BlockFace.WEST);
                } else {
                    if (ExecutorCategory.getByMaterial(block.getType()) != null && event.getPlayer().isSneaking()) {
                        for (int x = block.getX(); x < platform.getEndCoordinate() - 1; x += 2) {
                            Block actionBlock = block.getWorld().getBlockAt(x, block.getY(), block.getZ());
                            this.destroyAdditionalBlocks(platform, actionBlock, devPlanet.isDropItems());
                            actionBlock.setType(Material.AIR);
                        }
                    }
                    devPlanet.setCodeChanged(true);
                    this.destroyAdditionalBlocks(platform, block, devPlanet.isDropItems());
                    block.setType(Material.AIR);
                    devPlanet.clearMarkedExecutors(block.getLocation());
                }
                event.setCancelled(true);
            }
            if (block.getType() == devPlanet.getContainerMaterial() && ((blockAtDown = block.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN)).getType() == platform.getEventMaterial() || blockAtDown.getType() == platform.getActionMaterial())) {
                event.setCancelled(true);
            }
            if (block.getType().name().contains("WALL_SIGN")) {
                event.setCancelled(true);
                PlayerUtils.translateBlockSign(block, player);
            }
        } else if (planet != null) {
            if (ChangedWorld.isPlayerWithLocation(player) && !planet.getWorldPlayers().canBuild(player)) {
                player.sendActionBar(MessageUtils.getLocaleMessage("not-builder"));
                event.setCancelled(true);
                return;
            }
            new DestroyBlockEvent(event.getPlayer(), event).callEvent();
            if (!event.isCancelled()) {
                Menus.onBlockDestroy(event.getBlock().getLocation());
            }
        } else if (PlayerUtils.isEntityInLobby((Entity)player) && OpenCreative.getSettings().isLobbyDisallowDestroyingBlocks() && !player.hasPermission("opencreative.lobby.destroying-blocks.bypass")) {
            event.setCancelled(true);
            player.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
        }
    }

    private void destroyAdditionalBlocks(DevPlatform platform, Block block, boolean dropItems) {
        ItemStack[] itemStackArray;
        int closingBracketX;
        Block containerBlock = block.getRelative(BlockFace.UP);
        Block additionalBlock = block.getRelative(BlockFace.EAST);
        Block signBlock = block.getRelative(BlockFace.SOUTH);
        if (additionalBlock.getType() == Material.PISTON && (closingBracketX = BlockUtils.getClosingBracketX(platform, block)) != -1) {
            block.getWorld().getBlockAt(closingBracketX, block.getY(), block.getZ()).setType(Material.AIR);
        }
        additionalBlock.setType(Material.AIR);
        signBlock.setType(Material.AIR);
        Menus.onBlockDestroy(signBlock.getLocation());
        if (dropItems && (itemStackArray = containerBlock.getState()) instanceof InventoryHolder) {
            InventoryHolder container = (InventoryHolder)itemStackArray;
            Menus.onBlockDestroy(containerBlock.getLocation());
            for (ItemStack item : container.getInventory().getContents()) {
                if (item == null || item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(ItemUtils.getCodingDoNotDropMeKey())) continue;
                containerBlock.getWorld().dropItem(containerBlock.getLocation(), item);
            }
        }
        containerBlock.setType(Material.AIR);
    }

    @EventHandler
    public void onStartDamaging(BlockDamageEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new DamageBlockEvent(event.getPlayer(), event).callEvent();
        }
    }
}

