/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.plugin.Plugin;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class GameModeListener
implements Listener {
    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OpenCreative.getPlugin(), () -> {
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            if (planet == null) {
                if (PlayerUtils.isEntityInLobby((Entity)player) && event.getNewGameMode() == GameMode.CREATIVE && !player.hasPermission("opencreative.gamemode.change")) {
                    if (player.isConnected()) {
                        OpenCreative.getPlugin().getLogger().warning("Player " + player.getName() + " tried to get Creative mode in lobby, but he doesn't have permission.");
                    }
                    event.setCancelled(true);
                }
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (player.getWorld().equals((Object)onlinePlayer.getWorld())) continue;
                    PlayerUtils.hidePlayerInTab(onlinePlayer, player);
                    PlayerUtils.hidePlayerInTab(player, onlinePlayer);
                }
                return;
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (onlinePlayer.getWorld().equals((Object)planet.getTerritory().getWorld()) || onlinePlayer.getWorld().equals((Object)planet.getDevPlanet().getWorld())) continue;
                PlayerUtils.hidePlayerInTab(onlinePlayer, player);
                PlayerUtils.hidePlayerInTab(player, onlinePlayer);
            }
        }, 5L);
    }
}

