/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public final class PotionListener
implements Listener {
    private static final int POTION_AMPLIFIER_LIMIT = 100;

    @EventHandler
    public void onEvent(AreaEffectCloudApplyEvent event) {
        if (PotionListener.isCorrupted(event.getEntity().getCustomEffects())) {
            event.setCancelled(true);
            event.getEntity().remove();
        }
    }

    @EventHandler
    public void onEvent(PotionSplashEvent event) {
        if (PotionListener.isCorrupted(event.getEntity().getPotionMeta())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEvent(LingeringPotionSplashEvent event) {
        if (PotionListener.isCorrupted(event.getEntity().getPotionMeta())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEvent(EntityPotionEffectEvent event) {
        if (event.getOldEffect() != null && event.getOldEffect().getAmplifier() > 100) {
            event.setCancelled(true);
        }
        if (event.getNewEffect() != null && event.getNewEffect().getAmplifier() > 100) {
            event.setCancelled(true);
        }
    }

    public static boolean isCorrupted(List<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            if (effect.getAmplifier() <= 100) continue;
            return true;
        }
        return false;
    }

    public static boolean isCorrupted(PotionMeta potionMeta) {
        return PotionListener.isCorrupted(potionMeta.getCustomEffects());
    }
}

